use std::thread;
use crossbeam::channel;

pub trait Task {
    type Output: Send;
    fn run(&self) -> Option<Self::Output>;
}

pub struct WorkQueue<TaskType: 'static + Task + Send> {
    send_tasks: Option<channel::Sender<TaskType>>, // Option because it will be set to None to close the queue
    recv_tasks: channel::Receiver<TaskType>,
    //send_output: channel::Sender<TaskType::Output>, // not need in the struct: each worker will have its own clone.
    recv_output: channel::Receiver<TaskType::Output>,
    workers: Vec<thread::JoinHandle<()>>,
}

impl<TaskType: 'static + Task + Send> WorkQueue<TaskType> {
    pub fn new(n_workers: usize) -> WorkQueue<TaskType> {
        todo!(); // create the (unbounded) channels; start the worker threads; record their JoinHandles
    }

    fn run(recv_tasks: channel::Receiver<TaskType>, send_output: channel::Sender<TaskType::Output>) {
        // TODO: the main logic for a worker thread
        loop {
            let task_result = recv_tasks.recv();
            todo!(); // task_result will be Err() if the Sender has been destroyed and no more messages can be received here
        }
    }

    pub fn enqueue(&mut self, t: TaskType) -> Result<(), channel::SendError<TaskType>> {
        todo!(); // send this task to a worker
    }

    // Helper methods that let you receive results in various ways
    pub fn iter(&mut self) -> channel::Iter<'_, TaskType::Output> {
        self.recv_output.iter()
    }
    pub fn recv(&mut self) -> Result<TaskType::Output, crossbeam::channel::RecvError> {
        self.recv_output
            .recv()
    }
    pub fn try_recv(&mut self) -> Result<TaskType::Output, channel::TryRecvError> {
        self.recv_output.try_recv()
    }
    pub fn recv_timeout(
        &self,
        timeout: std::time::Duration,
    ) -> Result<TaskType::Output, channel::RecvTimeoutError> {
        self.recv_output.recv_timeout(timeout)
    }

    pub fn shutdown(&mut self) {
        // Destroy the Sender so everybody knows no more tasks are incoming.
        // Discard any pending tasks in the queue.
        // Wait for each worker thread to finish.
        // HINT: Vec.drain(..)
        todo!();
    }
}

impl<TaskType: 'static + Task + Send> Drop for WorkQueue<TaskType> {
    fn drop(&mut self) {
        // a "Finalisation in destructors" pattern: https://rust-unofficial.github.io/patterns/idioms/dtor-finally.html
        match self.send_tasks {
            None => {} // already shut down
            Some(_) => self.shutdown(),
        }
    }
}
