# -*- coding: utf-8 -*-

# There's no need to use this program in this Lab, but if you'd like to test on different
# Unicode strings, this Python code is what was used to generate test_strings.c and you're
# free to experiment with it.
# Likely usage:
# python3 make_test_strings.py > test_strings.c

# This list may be modified: just make sure you save this file as UTF-8 text.
strings = [
    'Hello World',
    'garçon',
    '\u00e9',
    'e\u0301',
    '谢谢… ขอบคุณ… धन्यवाद… 감사합니다',
    'Hello 😃',
    '🫱🏼‍🫲🏾',
]


def to_c(b: int) -> str:
    """
    A reasonable approximation of correct escaping for bytes in C string literals.
    """
    assert b < 256
    if b == 34:
        return '\\"'
    elif 32 <= b <= 127:
        return chr(b)
    else:
        return f'\\x{b:>02x}'


def main():
    n_strings = len(strings);
    c_strings = ',\n    '.join(
        '"' + ''.join([to_c(b) for b in s.encode('utf-8')]) + '"'
        for s in strings
    )
    u_lens = ', '.join(str(len(s)) for s in strings)
    b_lens = ', '.join(str(len(s.encode('utf-8'))) for s in strings)

    print(f'''// This file is generated by make_test_strings.py: if you'd like different test cases, start there.
unsigned n_strings = {n_strings};
const char* strings[] = {{
    {c_strings}
}};
uint64_t byte_lengths[] = {{{b_lens}}};
uint64_t utf8_lengths[] = {{{u_lens}}};''')


main()