#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <future>
#include <cassert>

#define TASKS 48

float* float_array(uint64_t length) {
    float* array = (float*)malloc(length * sizeof(float));
    if (array == NULL) {
        return NULL;
    }
    for (uint64_t i = 0; i < length; i++) {
        array[i] = ((float)rand() / RAND_MAX - 0.25);
    }
    return array;
}

float dot_single_c(float* arr1, float* arr2, uint64_t length) {
    float total = 0.0;
    for (uint64_t i = 0; i < length; i++) {
        total += arr1[i] * arr2[i];
    }
    return total;
}

uint64_t hailstone_length(uint64_t n) {
    bool is_even = n % 2 == 0;
    if (n == 1) {
        return 0;
    } else if (is_even) {
        return 1 + hailstone_length(n / 2);
    } else {
        return 1 + hailstone_length(3 * n + 1);
    }
}

uint64_t hailstone_total(uint64_t a, uint64_t b) {
    uint64_t total = 0;
    for( uint64_t i=a; i<b; i++) {
        total += hailstone_length(i);
    }
    return total;
}


float dot_single_threaded(float* arr1, float* arr2, uint64_t length) {
    assert(length % TASKS == 0);
    float total = 0.0;
    // TODO
    return total;
}

uint64_t hailstone_total_threaded(uint64_t a, uint64_t b) {
    assert((b-a) % TASKS == 0);
    uint64_t total = 0;
    // TODO
    return total;
}
