/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Policy;
import org.AIspace.ve.PolicyCompute;
import org.AIspace.ve.Query;
import org.AIspace.ve.QueryCompute;
import org.AIspace.ve.Variable;
import org.AIspace.ve.examples.FireXMLBIF;
import org.AIspace.ve.parsers.XMLBIFv0_3.DecisionNetworkFromXMLBIFv0_3;
import org.AIspace.ve.parsers.factors.DecisionNetworkFromFactors;

public class UmbrellaXMLBIF {
    public static void main(String[] args) {
        DecisionNetworkFromFactors decisionNetworkBis;
        DecisionNetwork decisionNetwork;
        Configuration configuration = new Configuration();
        System.out.println("\n* Configuration:");
        System.out.println(configuration.toString(false));
        System.out.println("* Loading the network.");
        try {
            decisionNetwork = DecisionNetworkFromXMLBIFv0_3.create(new BufferedReader(new InputStreamReader(FireXMLBIF.class.getResourceAsStream("umbrella.xml"))), configuration).getFirstElement().get(0);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("* '" + decisionNetwork.getName(false) + "' network loaded.");
        System.out.println();
        System.out.println(decisionNetwork.toString(false, false));
        System.out.println("\n*** Optimizing decisions:");
        PolicyCompute policy = new PolicyCompute(decisionNetwork, new Variable[0], new int[0], configuration);
        Policy.Result resultPolicy = policy.getResult();
        System.out.println("* Result:");
        System.out.println(resultPolicy.toString(false, true, false));
        try {
            decisionNetworkBis = new DecisionNetworkFromFactors(decisionNetwork, resultPolicy.getPolicy(false), configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("\n*** New decision network with optimal decision function:");
        System.out.println(decisionNetworkBis.toString(false, false));
        System.out.println("\n*** Querying 'Umbrella':");
        QueryCompute query = new QueryCompute(new Variable[]{decisionNetworkBis.getVariable("Umbrella")}, decisionNetworkBis, new Variable[0], new int[0], configuration);
        Query.Result resultQuery = query.getResult();
        System.out.println("* Result:");
        System.out.println(resultQuery.toString(false));
        System.out.println("\n*** Querying 'Umbrella' given observation 'Weather' = 'Rain':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(new Variable[]{decisionNetworkBis.getVariable("Umbrella")}, decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration).getResult().toString(false));
        System.out.println("\n*** Computing expected utility given observation 'Weather' = 'Rain':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration).getResult().toString(false));
        System.out.println("\n*** Optimizing decisions in the original network given observation 'Weather' = 'Rain':");
        policy = new PolicyCompute(decisionNetwork, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration);
        resultPolicy = policy.getResult();
        System.out.println("* Result:");
        System.out.println(resultPolicy.toString(false, true, false));
        try {
            decisionNetworkBis = new DecisionNetworkFromFactors(decisionNetwork, resultPolicy.getPolicy(false), configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("\n*** New decision network with optimal decision function (for observation 'Weather' = 'Rain'):");
        System.out.println(decisionNetworkBis.toString(false, false));
        System.out.println("\n*** Computing expected utility in the new network given observations 'Weather' = 'Rain' and 'Umbrella' = 'Leave_At_Home':");
        System.out.println("* Result:");
        try {
            System.out.println(new QueryCompute(decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather"), decisionNetworkBis.getVariable("Umbrella")}, new int[]{1, 1}, configuration).getResult().toString(false));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

