/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.domains;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.AIspace.ve.Unique;

@Immutable
public abstract class Domain<T>
implements Iterable<T>,
Comparable<Domain<?>>,
Unique {
    private AtomicInteger maxValueLength = new AtomicInteger(0);
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId = nextId.getAndIncrement();

    public abstract T getValue(int var1);

    public abstract int getValueIndex(Object var1);

    public abstract boolean containsValue(Object var1);

    public abstract int getSize();

    @Override
    public abstract Iterator<T> iterator();

    public final int getMaxElementLength() {
        if (this.maxValueLength.get() == 0) {
            int result = 0;
            for (T element : this) {
                result = Math.max(result, element.toString().length());
            }
            this.maxValueLength.set(result);
        }
        return this.maxValueLength.get();
    }

    @Override
    public final int getId() {
        return this.uniqueId;
    }

    protected Domain() {
    }

    public final boolean equals(Object domain) {
        return this.uniqueId == ((Domain)domain).uniqueId;
    }

    @Override
    public final int compareTo(Domain<?> domain) {
        return this.uniqueId - domain.uniqueId;
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    @Override
    public final String toString(boolean withId) {
        StringBuilder output = new StringBuilder();
        if (withId) {
            output.append("[").append(this.uniqueId).append("]");
        }
        output.append("{");
        for (T element : this) {
            output.append(element.toString()).append(", ");
        }
        output.delete(output.length() - 2, output.length());
        output.append("}");
        return output.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Domain has its own unique ID. It can't be cloned. Also it is virtually immutable so there is no much point in cloning.");
    }
}

