/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorDivide;
import org.AIspace.ve.FactorNormalise;
import org.AIspace.ve.FactorStore;
import org.AIspace.ve.FactorStoreIndexedBN;
import org.AIspace.ve.FactorStoreSequential;
import org.AIspace.ve.FactorUtility;
import org.AIspace.ve.Inference;
import org.AIspace.ve.MoralGraph;
import org.AIspace.ve.ObservedFactorsIterator;
import org.AIspace.ve.Policy;
import org.AIspace.ve.QueryCompute;
import org.AIspace.ve.QueryPretend;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrArray;

public abstract class Query
extends Inference {
    final Result result;

    @Override
    public Result getResult() {
        return this.result.clone();
    }

    Query(Variable[] queryVars, DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(configuration);
        String error = Query.checkInput(queryVars, decisionNetwork, observedVars, observedVals, configuration);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.result = new Result(configuration);
    }

    Query(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(configuration);
        String error = Query.checkInput(decisionNetwork, observedVars, observedVals, configuration);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.result = new Result(configuration);
    }

    Query(Configuration configuration) {
        super(configuration);
        this.result = new Result(configuration);
    }

    Query(Query query) {
        super(query);
        this.result = query.result.clone();
    }

    static final Variable[] determineToSumOut(Iterator<Variable> allVarsIterator, int nrAllVars, Variable[] queryVars, Variable[] observedVars) {
        Variable[] res = new Variable[nrAllVars - queryVars.length - observedVars.length];
        int qpos = 0;
        int opos = 0;
        int respos = 0;
        while (allVarsIterator.hasNext()) {
            Variable variable = allVarsIterator.next();
            if (qpos < queryVars.length && queryVars[qpos].equals(variable)) {
                ++qpos;
                continue;
            }
            if (opos < observedVars.length && observedVars[opos].equals(variable)) {
                ++opos;
                continue;
            }
            res[respos++] = variable;
        }
        return res;
    }

    static final Variable[] determineToSumOut(Iterator<Variable> allVarsIterator, int nrAllVars, Variable[] observedVars) {
        Variable[] res = new Variable[nrAllVars - observedVars.length];
        int opos = 0;
        int respos = 0;
        while (allVarsIterator.hasNext()) {
            Variable variable = allVarsIterator.next();
            if (opos < observedVars.length && observedVars[opos].equals(variable)) {
                ++opos;
                continue;
            }
            res[respos++] = variable;
        }
        return res;
    }

    public static final String checkInput(Variable[] queryVars, DecisionNetwork dnet, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        if (dnet == null) {
            return "Decision Network is 'null'.";
        }
        if (!dnet.isConstructionFinished()) {
            return "Decision Network is not fully constructed.";
        }
        if (dnet.isDecisionNetwork() && !dnet.isPolicyDefined()) {
            return "Policy function undefined for the decision network.";
        }
        if (queryVars == null) {
            return "Query variables array is 'null'.";
        }
        if (observedVars == null) {
            return "Observed variables array is 'null'.";
        }
        if (observedVals == null) {
            return "Observed values array is 'null'.";
        }
        if (queryVars.length == 0 && observedVars.length == 0) {
            return "At least one query or observed variable needs to be provided.";
        }
        if (observedVars.length != observedVals.length) {
            return "The number of the observed Variables is different from the number of values provided.";
        }
        int queryIndex = 0;
        int observedIndex = 0;
        boolean existElements = queryIndex < queryVars.length && observedIndex < observedVars.length;
        while (existElements) {
            if (queryVars[queryIndex] == null) {
                return "Query Variable number " + queryIndex + " is 'null'.";
            }
            if (observedVars[observedIndex] == null) {
                return "Observed Variable number " + observedIndex + " is 'null'.";
            }
            if (queryVars[queryIndex].compareTo(observedVars[observedIndex]) < 0) {
                if (queryIndex < queryVars.length - 1) {
                    if (!dnet.containsVariable(queryVars[queryIndex])) {
                        return "Query Variable (" + queryVars[queryIndex].getName(true) + ") is not in the network.";
                    }
                    if (queryVars[queryIndex].compareTo(queryVars[queryIndex + 1]) >= 0) {
                        return "Query Variables are not in order.";
                    }
                    ++queryIndex;
                    continue;
                }
                existElements = false;
                continue;
            }
            if (queryVars[queryIndex].compareTo(observedVars[observedIndex]) > 0) {
                if (observedIndex < observedVars.length - 1) {
                    if (!dnet.containsVariable(observedVars[observedIndex])) {
                        return "Observed variable (" + observedVars[observedIndex].getName(true) + ") is not in the network.";
                    }
                    if (observedVals[observedIndex] < 0 || observedVals[observedIndex] >= observedVars[observedIndex].getDomain().getSize()) {
                        return "Invalid observation for variable " + observedVars[observedIndex].getName(true) + ".";
                    }
                    if (observedVars[observedIndex].compareTo(observedVars[observedIndex + 1]) >= 0) {
                        return "Observed variables are not in order.";
                    }
                    ++observedIndex;
                    continue;
                }
                existElements = false;
                continue;
            }
            return "Observed variables can not be query variables.";
        }
        int i = queryIndex;
        while (i < queryVars.length) {
            if (queryVars[i] == null) {
                return "Query variable number " + i + " is 'null'.";
            }
            if (!dnet.containsVariable(queryVars[i])) {
                return "Query variable (" + queryVars[i].getName(true) + ") is not in the network.";
            }
            if (i < queryVars.length - 1 && queryVars[i].compareTo(queryVars[i + 1]) >= 0) {
                return "Query variables are not in order.";
            }
            ++i;
        }
        i = observedIndex;
        while (i < observedVars.length) {
            if (observedVars[i] == null) {
                return "Observed variable number " + i + " is 'null'.";
            }
            if (!dnet.containsVariable(observedVars[observedIndex])) {
                return "Observed variable (" + observedVars[observedIndex].getName(true) + ") is not in the network.";
            }
            if (observedVals[i] < 0 || observedVals[i] >= observedVars[i].getDomain().getSize()) {
                return "Invalid observation for variable " + observedVars[i].getName(true) + ".";
            }
            if (i < observedVars.length - 1 && observedVars[i].compareTo(observedVars[i + 1]) >= 0) {
                return "Observed Variables are not in order.";
            }
            ++i;
        }
        if (configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN)) {
            Variable[] toSumOut = Query.determineToSumOut(dnet.getVariables(), dnet.getNumVariables(), queryVars, observedVars);
            Object[] givenOrdering = new Variable[configuration.eliminationOrdering().length];
            if (givenOrdering.length != toSumOut.length) {
                return "Given elimination ordering is incorrect.";
            }
            System.arraycopy(configuration.eliminationOrdering(), 0, givenOrdering, 0, givenOrdering.length);
            Arrays.sort(givenOrdering);
            int i2 = 0;
            while (i2 < toSumOut.length) {
                if (!toSumOut[i2].equals(givenOrdering[i2])) {
                    return "Given elimination ordering is incorrect.";
                }
                ++i2;
            }
        }
        return null;
    }

    public static final String checkInput(DecisionNetwork dnet, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        if (dnet == null) {
            return "Decision network is 'null'.";
        }
        if (!dnet.isConstructionFinished()) {
            return "Decision network is not fully constructed.";
        }
        if (!dnet.isDecisionNetwork()) {
            return "Provided network is not a decision network.";
        }
        if (!dnet.isPolicyDefined()) {
            return "Policy function undefined for the decision network.";
        }
        if (observedVars == null) {
            return "Observed variables array is 'null'.";
        }
        if (observedVals == null) {
            return "Observed values array is 'null'.";
        }
        if (observedVars.length != observedVals.length) {
            return "The number of the observed variables is different from the number of values provided.";
        }
        int i = 0;
        while (i < observedVars.length) {
            if (observedVars[i] == null) {
                return "Observed variable number " + i + " is 'null'.";
            }
            if (!dnet.containsVariable(observedVars[i])) {
                return "Observed variable (" + observedVars[i].getName(true) + ") is not in the network.";
            }
            if (observedVals[i] < 0 || observedVals[i] >= observedVars[i].getDomain().getSize()) {
                return "Invalid observation for variable " + observedVars[i].getName(true) + ".";
            }
            if (i < observedVars.length - 1 && observedVars[i].compareTo(observedVars[i + 1]) >= 0) {
                return "Observed variables are not in order.";
            }
            ++i;
        }
        if (configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN)) {
            Variable[] toSumOut = Query.determineToSumOut(dnet.getVariables(), dnet.getNumVariables(), observedVars);
            Object[] givenOrdering = new Variable[configuration.eliminationOrdering().length];
            if (givenOrdering.length != toSumOut.length) {
                return "Given elimination ordering is incorrect.";
            }
            System.arraycopy(configuration.eliminationOrdering(), 0, givenOrdering, 0, givenOrdering.length);
            Arrays.sort(givenOrdering);
            int i2 = 0;
            while (i2 < toSumOut.length) {
                if (!toSumOut[i2].equals(givenOrdering[i2])) {
                    return "Given elimination ordering is incorrect.";
                }
                ++i2;
            }
        }
        return null;
    }

    static void markRelevantNodes(Variable[] queryVars, DecisionNetwork decisionNetwork, Iterator<Variable> observedVariablesIterator, Set<Variable> relevantVariables, Set<Variable> observedVariables) {
        DecisionNetwork.DNGraph graph = decisionNetwork.getGraph();
        while (observedVariablesIterator.hasNext()) {
            Variable observedVariable = observedVariablesIterator.next();
            observedVariables.add(observedVariable);
            graph.markRelevant(relevantVariables, observedVariable);
        }
        if (queryVars.length > 0) {
            Variable[] variableArray = queryVars;
            int n = queryVars.length;
            int n2 = 0;
            while (n2 < n) {
                Variable queryVariable = variableArray[n2];
                graph.markRelevant(relevantVariables, queryVariable);
                ++n2;
            }
            Iterator<Variable> variablesIterator = decisionNetwork.getVariables();
            while (variablesIterator.hasNext()) {
                Variable variable = variablesIterator.next();
                if (relevantVariables.contains(variable)) continue;
                graph.removeNode(variable);
            }
            MoralGraph moralGraph = new MoralGraph(graph);
            relevantVariables.clear();
            Variable[] variableArray2 = queryVars;
            int n3 = queryVars.length;
            int n4 = 0;
            while (n4 < n3) {
                Variable queryVariable = variableArray2[n4];
                moralGraph.markRelevant(relevantVariables, queryVariable, observedVariables, decisionNetwork);
                ++n4;
            }
        }
    }

    final void performInference(Variable[] queryVars, DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals) {
        FactorStore factors;
        Variable[] toSumOut;
        int variablesNum;
        Iterator<Variable> variablesIterator2;
        this.result.maxFactorSize = decisionNetwork.getMaxFactorSize();
        this.result.maxStoredFactorSize = decisionNetwork.getMaxFactorSize();
        Iterator<Variable> variablesIterator1 = decisionNetwork.getVariables();
        Iterator<Factor> factorsIterator = decisionNetwork.getFactors(false);
        int factorsNum = decisionNetwork.getNumProbFactors();
        if (this.configuration.getPruneIrrelevantVariables()) {
            HashSet<Variable> relevantVariables = new HashSet<Variable>();
            HashSet<Variable> observedVariables = new HashSet<Variable>();
            Query.markRelevantNodes(queryVars, decisionNetwork, new ItrArray<Variable>(observedVars, observedVars.length), relevantVariables, observedVariables);
            LinkedList<Variable> variablesList = new LinkedList<Variable>();
            while (variablesIterator1.hasNext()) {
                Variable variable = variablesIterator1.next();
                if (relevantVariables.contains(variable)) {
                    variablesList.add(variable);
                    continue;
                }
                this.result.prunedVariables.add(variable);
            }
            variablesIterator1 = variablesList.iterator();
            variablesIterator2 = variablesList.iterator();
            variablesNum = variablesList.size();
            Variable[] observedVarsTemp = new Variable[observedVars.length];
            int[] observedValsTemp = new int[observedVals.length];
            int posInTemp = 0;
            int i = 0;
            while (i < observedVars.length) {
                if (relevantVariables.contains(observedVars[i])) {
                    observedVarsTemp[posInTemp] = observedVars[i];
                    observedValsTemp[posInTemp++] = observedVals[i];
                } else {
                    this.result.prunedVariables.add(observedVars[i]);
                }
                ++i;
            }
            observedVars = new Variable[posInTemp];
            observedVals = new int[posInTemp];
            System.arraycopy(observedVarsTemp, 0, observedVars, 0, posInTemp);
            System.arraycopy(observedValsTemp, 0, observedVals, 0, posInTemp);
            LinkedList<Factor> factorsList = new LinkedList<Factor>();
            block2: while (factorsIterator.hasNext()) {
                Factor factor = (Factor)factorsIterator.next();
                Variable childVariable = ((FactorDirected)((Object)factor)).getChild();
                if (!relevantVariables.contains(childVariable)) continue;
                if (!observedVariables.contains(childVariable)) {
                    factorsList.add(factor);
                    continue;
                }
                if (queryVars.length == 0) {
                    factorsList.add(factor);
                    continue;
                }
                int i2 = 0;
                while (i2 < factor.getVariablesNum()) {
                    Variable factorVariable;
                    if (i2 != ((FactorDirected)((Object)factor)).getChildIndex() && !observedVariables.contains(factorVariable = factor.getVariable(i2))) {
                        if (!relevantVariables.contains(factorVariable)) continue block2;
                        factorsList.add(factor);
                        continue block2;
                    }
                    ++i2;
                }
            }
            factorsIterator = factorsList.iterator();
            factorsNum = factorsList.size();
        } else {
            variablesIterator2 = decisionNetwork.getVariables();
            variablesNum = decisionNetwork.getNumVariables();
        }
        ObservedFactorsIterator observedFactorsIterator = observedVars.length > 0 ? new ObservedFactorsIterator(factorsIterator, observedVars, observedVals, false, this.configuration.getFactorSavingForTracing()) : factorsIterator;
        if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN) || this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.RANDOM) || this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.SEQUENTIAL)) {
            if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN)) {
                toSumOut = this.result.prunedVariables.size() == 0 ? this.configuration.eliminationOrdering() : Variable.diffVars2(this.configuration.eliminationOrdering(), this.result.prunedVariables);
            } else {
                toSumOut = Query.determineToSumOut(variablesIterator1, variablesNum, queryVars, observedVars);
                if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.RANDOM)) {
                    Variable.shuffle(toSumOut);
                }
            }
            factors = new FactorStoreSequential(toSumOut, observedFactorsIterator, factorsNum);
        } else {
            toSumOut = Query.determineToSumOut(variablesIterator1, variablesNum, queryVars, observedVars);
            factors = new FactorStoreIndexedBN(decisionNetwork, toSumOut, observedFactorsIterator, factorsNum, variablesIterator2, variablesNum, this.configuration.getEliminationHeuristic());
        }
        this.result.factor = this.eliminateVariables(factors);
        if (queryVars.length != 0) {
            this.result.normFactor = new FactorNormalise(this.result.factor);
        }
    }

    final void performInference(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals) {
        FactorStore factors;
        Variable[] toSumOut;
        ObservedFactorsIterator observedFactorsIteratorST;
        int factorsNum;
        int variablesNum;
        Iterator<Variable> variablesIteratorST;
        this.result.maxFactorSize = decisionNetwork.getMaxFactorSize();
        this.result.maxStoredFactorSize = decisionNetwork.getMaxFactorSize();
        Iterator<Variable> variablesIteratorSO = decisionNetwork.getVariables();
        Iterator<Variable> variablesIteratorPE = null;
        Iterator<Factor> factorsIteratorST = decisionNetwork.getFactors(true);
        Iterator<Factor> factorsIteratorPE = null;
        if (this.configuration.getPruneIrrelevantVariables()) {
            HashSet<Variable> relevantVariables = new HashSet<Variable>();
            HashSet<Variable> observedVariables = new HashSet<Variable>();
            Policy.markRelevantNodes(decisionNetwork, new ItrArray<Variable>(observedVars, observedVars.length), relevantVariables, observedVariables);
            LinkedList<Variable> variablesList = new LinkedList<Variable>();
            while (variablesIteratorSO.hasNext()) {
                Variable variable = variablesIteratorSO.next();
                if (relevantVariables.contains(variable)) {
                    variablesList.add(variable);
                    continue;
                }
                this.result.prunedVariables.add(variable);
            }
            variablesIteratorSO = variablesList.iterator();
            variablesIteratorST = variablesList.iterator();
            variablesNum = variablesList.size();
            Variable[] observedVarsTemp = new Variable[observedVars.length];
            int[] observedValsTemp = new int[observedVals.length];
            int posInTemp = 0;
            int i = 0;
            while (i < observedVars.length) {
                if (relevantVariables.contains(observedVars[i])) {
                    observedVarsTemp[posInTemp] = observedVars[i];
                    observedValsTemp[posInTemp++] = observedVals[i];
                } else {
                    this.result.prunedVariables.add(observedVars[i]);
                }
                ++i;
            }
            observedVars = new Variable[posInTemp];
            observedVals = new int[posInTemp];
            System.arraycopy(observedVarsTemp, 0, observedVars, 0, posInTemp);
            System.arraycopy(observedValsTemp, 0, observedVals, 0, posInTemp);
            LinkedList<Factor> factorsList = new LinkedList<Factor>();
            block2: while (factorsIteratorST.hasNext()) {
                Factor factor = (Factor)factorsIteratorST.next();
                if (!(factor instanceof FactorUtility)) {
                    Variable childVariable = ((FactorDirected)((Object)factor)).getChild();
                    if (!relevantVariables.contains(childVariable)) continue;
                    if (!observedVariables.contains(childVariable)) {
                        factorsList.add(factor);
                        continue;
                    }
                    int i2 = 0;
                    while (i2 < factor.getVariablesNum()) {
                        Variable factorVariable;
                        if (i2 != ((FactorDirected)((Object)factor)).getChildIndex() && !observedVariables.contains(factorVariable = factor.getVariable(i2))) {
                            if (!relevantVariables.contains(factorVariable)) continue block2;
                            factorsList.add(factor);
                            continue block2;
                        }
                        ++i2;
                    }
                    continue;
                }
                factorsList.add(factor);
            }
            factorsIteratorST = factorsList.iterator();
            factorsNum = factorsList.size();
            if (observedVars.length != 0 && factorsNum > 1) {
                variablesIteratorPE = variablesList.iterator();
                factorsIteratorPE = factorsList.listIterator(1);
            }
        } else {
            variablesIteratorST = decisionNetwork.getVariables();
            variablesNum = decisionNetwork.getNumVariables();
            factorsNum = decisionNetwork.getNumProbFactors() + 1;
            if (observedVars.length != 0) {
                variablesIteratorPE = decisionNetwork.getVariables();
                factorsIteratorPE = decisionNetwork.getFactors(false);
            }
        }
        ObservedFactorsIterator observedFactorsIteratorPE = null;
        if (observedVars.length != 0) {
            observedFactorsIteratorST = new ObservedFactorsIterator(factorsIteratorST, observedVars, observedVals, this.configuration.getPruneIrrelevantVariables() && factorsIteratorPE != null, this.configuration.getFactorSavingForTracing());
            if (factorsIteratorPE != null) {
                observedFactorsIteratorPE = new ObservedFactorsIterator(factorsIteratorPE, observedVars, observedVals, false, this.configuration.getFactorSavingForTracing());
            }
        } else {
            observedFactorsIteratorST = factorsIteratorST;
        }
        FactorStore factorsPE = null;
        if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN) || this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.RANDOM) || this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.SEQUENTIAL)) {
            if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN)) {
                toSumOut = this.result.prunedVariables.size() == 0 ? this.configuration.eliminationOrdering() : Variable.diffVars2(this.configuration.eliminationOrdering(), this.result.prunedVariables);
            } else {
                toSumOut = Query.determineToSumOut(variablesIteratorSO, variablesNum, observedVars);
                if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.RANDOM)) {
                    Variable.shuffle(toSumOut);
                }
            }
            factors = new FactorStoreSequential(toSumOut, observedFactorsIteratorST, factorsNum);
            if (!(observedFactorsIteratorPE == null || this.configuration.getPruneIrrelevantVariables() && observedFactorsIteratorST.getRelevantObsNum() <= 0)) {
                factorsPE = new FactorStoreSequential(toSumOut, observedFactorsIteratorPE, factorsNum - 1);
            }
        } else {
            toSumOut = Query.determineToSumOut(variablesIteratorSO, variablesNum, observedVars);
            factors = new FactorStoreIndexedBN(decisionNetwork, toSumOut, observedFactorsIteratorST, factorsNum, variablesIteratorST, variablesNum, this.configuration.getEliminationHeuristic());
            if (!(observedFactorsIteratorPE == null || this.configuration.getPruneIrrelevantVariables() && observedFactorsIteratorST.getRelevantObsNum() <= 0)) {
                factorsPE = new FactorStoreIndexedBN(decisionNetwork, toSumOut, observedFactorsIteratorPE, factorsNum - 1, variablesIteratorPE, variablesNum, this.configuration.getEliminationHeuristic());
            }
        }
        this.result.factor = this.eliminateVariables(factors);
        if (factorsPE == null) {
            this.result.normFactor = this.result.factor;
        } else {
            this.result.evidenceQueryResult = this.getClass().equals(QueryCompute.class) ? new QueryCompute(factorsPE, this.configuration).getResult() : new QueryPretend(factorsPE, this.configuration).getResult();
            if (this.result.evidenceQueryResult.getFactor().iterator().next() == 0.0) {
                throw new ArithmeticException("Probability of evidence is 0.0.");
            }
            this.result.normFactor = new FactorDivide(this.result.factor, this.result.evidenceQueryResult.getFactor(), this.configuration.getFactorSavingForTracing());
        }
    }

    abstract Factor eliminateVariables(FactorStore var1);

    public static final class Result
    extends Inference.Result {
        Result(Configuration configuration) {
            super(configuration);
        }

        public Result(String fileName, Configuration configuration) {
            super(configuration);
        }

        private Result(Result result) {
            super(result);
        }

        @Override
        public void save() {
        }

        @Override
        public String toString(boolean withId) {
            return super.toString(withId);
        }

        @Override
        public String toString() {
            return this.toString(true);
        }

        @Override
        public Result clone() {
            return new Result(this);
        }
    }
}

