/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.Variable;

@Immutable
public class FactorConstant
extends Factor {
    private final double constant;

    public double getConstant() {
        return this.constant;
    }

    @Override
    public final double getValue(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw new IllegalArgumentException("Given index is outside of the proper range.");
        }
        return this.constant;
    }

    public FactorConstant(Variable[] variables, boolean copyVariables, double constant) {
        super(variables, copyVariables);
        this.constant = constant;
    }

    @Override
    public FactorIterator iterator() {
        return new FactorIterator(){
            private long curpos = 0L;

            @Override
            public boolean hasNext() {
                return this.curpos < FactorConstant.this.getSize();
            }

            @Override
            public double next() {
                if (this.curpos < FactorConstant.this.getSize()) {
                    ++this.curpos;
                    return FactorConstant.this.constant;
                }
                throw new NoSuchElementException();
            }

            @Override
            public long currPos() {
                return this.curpos;
            }

            @Override
            public void backTo(long pos) {
                if (pos < 0L || pos >= FactorConstant.this.getSize()) {
                    throw new IllegalArgumentException();
                }
                this.curpos = pos;
            }
        };
    }
}

