/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDistribution;
import org.AIspace.ve.FactorInterpretable;
import org.AIspace.ve.FactorStored;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrArraySkip;

public final class FactorCPT
extends FactorStored
implements FactorDistribution,
FactorInterpretable {
    private final int childIndex;
    private AtomicLong verifiedThreshold = new AtomicLong(-1L);

    @Override
    public final int getChildIndex() {
        return this.childIndex;
    }

    @Override
    public final Variable getChild() {
        return this.variables[this.childIndex];
    }

    @Override
    public Iterator<Variable> getParents() {
        return new ItrArraySkip<Variable>(this.variables, this.childIndex);
    }

    @Override
    public boolean isDistribution(double threshold) {
        if (threshold < 0.0) {
            return true;
        }
        long convertedThreshold = Double.doubleToLongBits(threshold);
        if (this.verifiedThreshold.get() <= convertedThreshold) {
            return true;
        }
        if (this.isCPDimproper(threshold)) {
            return false;
        }
        this.verifiedThreshold.set(convertedThreshold);
        return true;
    }

    public FactorCPT(Variable[] variables, boolean copyVariables, int childIndex, String values, Pattern separator, double threshold) {
        super(variables, copyVariables, values, separator);
        if (childIndex < 0 || childIndex > variables.length) {
            throw new IllegalArgumentException("Child index out of bounds!");
        }
        this.childIndex = childIndex;
        this.hasBeenReordered = false;
        if (threshold >= 0.0 && this.isCPDimproper(threshold)) {
            throw new IllegalArgumentException("Provided values do not describe a proper conditional probability distribution.");
        }
        this.verifiedThreshold.set(Double.doubleToLongBits(threshold));
    }

    public FactorCPT(Variable[] variables, boolean copyVariables, int childIndex, double[] values, boolean copyValues, double threshold) {
        super(variables, copyVariables, values, copyValues);
        if (childIndex < 0 || childIndex > variables.length) {
            throw new IllegalArgumentException("Child index out of bounds!");
        }
        this.childIndex = childIndex;
        this.hasBeenReordered = false;
        if (threshold >= 0.0 && this.isCPDimproper(threshold)) {
            throw new IllegalArgumentException("Provided values do not describe a proper conditional probability distribution.");
        }
        this.verifiedThreshold.set(Double.doubleToLongBits(threshold));
    }

    private boolean isCPDimproper(double threshold) {
        int valuesBefore = 1;
        int i = 0;
        while (i < this.childIndex) {
            valuesBefore *= this.variables[i].getDomain().getSize();
            ++i;
        }
        int valuesChild = this.variables[this.childIndex].getDomain().getSize();
        int valuesAfter = 1;
        int i2 = this.childIndex + 1;
        while (i2 < this.variables.length) {
            valuesAfter *= this.variables[i2].getDomain().getSize();
            ++i2;
        }
        i2 = 0;
        while (i2 < valuesBefore) {
            int index = i2 * valuesChild * valuesAfter;
            int j = 0;
            while (j < valuesAfter) {
                double sum = 0.0;
                int index2 = index + j;
                int k = 0;
                while (k < valuesChild) {
                    sum += this.getValue(index2 + k * valuesAfter);
                    ++k;
                }
                if (Math.abs(1.0 - sum) > threshold) {
                    return true;
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public String getInterpretationFunctor() {
        return "P";
    }

    @Override
    public String getInterpretation(boolean withId) {
        if (this.childIndex < 0) {
            return this.getName(withId);
        }
        StringBuilder nameString = withId ? new StringBuilder("[" + this.getId() + "]" + this.getInterpretationFunctor() + "(") : new StringBuilder(String.valueOf(this.getInterpretationFunctor()) + "(");
        nameString.append(this.variables[this.childIndex].getName(withId));
        if (this.variables.length > 1) {
            nameString.append(" | ");
            int i = 0;
            while (i < this.variables.length) {
                if (i != this.childIndex) {
                    nameString.append(this.variables[i].getName(withId)).append(", ");
                }
                ++i;
            }
            nameString.delete(nameString.length() - 2, nameString.length());
        }
        return nameString.append(")").toString();
    }

    @Override
    public FactorCPT getReorderedFactor() {
        return (FactorCPT)super.getReorderedFactor();
    }

    @Override
    public FactorCPT reorder(boolean saveForTracing) {
        return this.reorder(Variable.sort(this.variables), false, saveForTracing);
    }

    @Override
    public FactorCPT reorder(Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        int[] newToOldIndex = null;
        if (saveForTracing) {
            newToOldIndex = new int[(int)this.getSize()];
        }
        FactorCPT result = new FactorCPT(newOrder, copyOrder, FactorCPT.findVariable(this.getChild(), newOrder), Factor.reorderValues(this, newOrder, newToOldIndex), false, Double.MAX_VALUE);
        if (saveForTracing) {
            result.reorderedFactor = this;
            result.newToOldIndex = newToOldIndex;
        }
        result.hasBeenReordered = true;
        return result;
    }

    static int findVariable(Variable variable, Variable[] variables) {
        int result = -1;
        int i = 0;
        while (i < variables.length) {
            if (variable.equals(variables[i])) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }
}

