/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDeltaMax;
import org.AIspace.ve.FactorDeltaMin;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorDistribution;
import org.AIspace.ve.FactorFactorized;
import org.AIspace.ve.FactorInterpretable;
import org.AIspace.ve.FactorUtility;
import org.AIspace.ve.Graph;
import org.AIspace.ve.NamedAndUnique;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.VariableNature;
import org.AIspace.ve.properties.Property;
import org.AIspace.ve.tools.ItrIterator;
import org.AIspace.ve.tools.PairComparable;

public abstract class DecisionNetwork
implements NamedAndUnique {
    static final boolean ENFORCE_ACYCLICITY_DEFAULT = true;
    static final boolean FACTORIZE_NOISY_FACTORS_DEFAULT = true;
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;
    private String name = "";
    private final UserPropertiesHolder networkProperties = new UserPropertiesHolder();
    private boolean isDecisionNetwork = false;
    private boolean isPolicyDefined = true;
    private boolean isNoForgetting;
    private final boolean factorSavingForTracing;
    private final double factorDistributionThreshold;
    private final boolean enforceAcylicity;
    private final boolean factorizeNoisyFactors;
    private UserPropertiesHolder utilityProperties;
    private final TreeMap<Variable, VariableProperties> variableToProperties;
    private final HashMap<String, Variable> nameToVar;
    private final LinkedList<Factor> factors;
    private long maxFactorSize;
    private DNGraph graph;
    private boolean constructionFinished;

    @Override
    public final int getId() {
        return this.uniqueId;
    }

    public final void setName(String name) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Provided name is null.");
        }
        this.name = name;
    }

    @Override
    public final String getName(boolean withId) {
        if (withId) {
            return String.valueOf(this.name) + "[#" + this.uniqueId + "]";
        }
        return this.name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void addProperty(Property property) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (property == null) {
            throw new IllegalArgumentException("Provided property is null.");
        }
        if (!this.networkProperties.add(property)) {
            throw new IllegalArgumentException("Provided property ('" + property.getName() + "') is already in the network.");
        }
    }

    public final void addProperties(Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        this.networkProperties.add(propertiesIterator);
    }

    public final UserPropertiesHolder properties() {
        return this.networkProperties;
    }

    public final boolean isDecisionNetwork() {
        return this.isDecisionNetwork;
    }

    public final boolean isPolicyDefined() {
        if (!this.isDecisionNetwork) {
            throw new UnsupportedOperationException("This is not a decision network.");
        }
        return this.isPolicyDefined;
    }

    public final boolean isNoForgetting() {
        return this.isNoForgetting;
    }

    public final boolean factorSavingForTracing() {
        return this.factorSavingForTracing;
    }

    public final double factorStructuredThreshold() {
        return this.factorDistributionThreshold;
    }

    public final boolean enforceAcyclicity() {
        return this.enforceAcylicity;
    }

    public final boolean factorizeNoisyFactors() {
        return this.factorizeNoisyFactors;
    }

    public final SamplesFactory getSamplesFactory(Random generator) {
        return new SamplesFactory(generator);
    }

    public final UserPropertiesHolder utilityProperties() {
        return this.utilityProperties;
    }

    public final FactorUtility getUtility() {
        if (this.isDecisionNetwork) {
            return (FactorUtility)this.factors.getFirst();
        }
        throw new UnsupportedOperationException("This is not a decision network.");
    }

    public final void addUtility(FactorUtility utility, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (this.factors.getFirst() != null) {
            throw new UnsupportedOperationException("Utility is already defined for this network.");
        }
        Iterator<Variable> variablesIterator = utility.getVariables();
        while (variablesIterator.hasNext()) {
            Variable variable = variablesIterator.next();
            if (this.variableToProperties.containsKey(variable)) continue;
            throw new UnsupportedOperationException("Variable " + variable.getName(false) + " is not in the network.");
        }
        this.utilityProperties = new UserPropertiesHolder(propertiesIterator);
        this.factors.removeFirst();
        if (utility.isProperlyOrdered()) {
            this.factors.addFirst(utility);
        } else {
            this.factors.addFirst(utility.reorder(this.factorSavingForTracing));
        }
        this.isDecisionNetwork = true;
    }

    public final void addVariable(Variable variable, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        Variable previousValue = this.nameToVar.put(variable.getName(false), variable);
        if (previousValue != null) {
            this.nameToVar.put(variable.getName(false), previousValue);
            throw new IllegalArgumentException("Variable with the same name (" + variable.getName(false) + ") is already in the network.");
        }
        try {
            this.variableToProperties.put(variable, new VariableProperties(propertiesIterator));
        }
        catch (IllegalArgumentException e) {
            this.nameToVar.remove(variable);
            throw e;
        }
        this.graph.addNode(variable);
        if (variable instanceof VariableDecision) {
            this.isDecisionNetwork = true;
        }
    }

    public final int getNumVariables() {
        return this.variableToProperties.size();
    }

    public final boolean containsVariable(Variable variable) {
        return this.variableToProperties.containsKey(variable);
    }

    public final Iterator<Variable> getVariables() {
        return new ItrIterator<Variable>(this.variableToProperties.keySet().iterator());
    }

    public final Variable getVariable(String variableName) {
        return this.nameToVar.get(variableName);
    }

    public final VariableProperties variableProperties(Variable variable) {
        VariableProperties allProperties = this.variableToProperties.get(variable);
        if (allProperties == null) {
            throw new IllegalArgumentException("Variable '" + variable.getName(false) + "' is not in the network.");
        }
        return allProperties;
    }

    /*
     * Unable to fully structure code
     */
    public final void addFactor(Factor factor, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (!(factor instanceof FactorDirected)) {
            throw new IllegalArgumentException("Factor does not specify a child variable.");
        }
        child = ((FactorDirected)factor).getChild();
        if (this.graph.getParentsNum(child) != 0) {
            throw new IllegalArgumentException("Parents for this variable ('" + child.getName(false) + "') are already in the network.");
        }
        if (!(factor instanceof FactorDistribution)) {
            throw new IllegalArgumentException("Factor does not represent a probability distribution.");
        }
        if (!((FactorDistribution)factor).isDistribution(this.factorDistributionThreshold)) {
            throw new IllegalArgumentException("Factor does not represent a conditional probability distribution with a required precision.");
        }
        if (!factor.isProperlyOrdered()) {
            factor = factor.reorder(this.factorSavingForTracing);
        }
        childProperties = this.variableToProperties.get(child);
        try {
            UserPropertiesHolder.access$3(VariableProperties.access$2(childProperties), propertiesIterator);
        }
        catch (IllegalArgumentException e) {
            UserPropertiesHolder.access$4(VariableProperties.access$2(childProperties));
            throw e;
        }
        if (factor instanceof FactorFactorized && this.factorizeNoisyFactors) {
            childPrim = ((FactorFactorized)factor).getChildPrim();
            try {
                this.addVariable(childPrim, null);
            }
            catch (IllegalArgumentException e) {
                UserPropertiesHolder.access$4(VariableProperties.access$2(childProperties));
                throw new IllegalArgumentException("Error while adding an additional factorization variable " + childPrim.getName(false) + ".");
            }
            childPrimProperties = this.variableToProperties.get(childPrim);
            oldMaxFactorSize = this.maxFactorSize;
            factorization = ((FactorFactorized)factor).getFactorization();
            while (factorization.hasNext()) {
                block24: {
                    factorF = factorization.next();
                    try {
                        if (factorF instanceof FactorDeltaMax || factorF instanceof FactorDeltaMin) {
                            this.graph.addParent(child, childPrim, this.enforceAcylicity);
                            this.factors.add(factorF);
                            VariableProperties.access$0(childProperties).add(factorF);
                        } else {
                            this.graph.addParent(childPrim, factorF.getVariable(0), this.enforceAcylicity);
                            this.factors.add(factorF);
                            VariableProperties.access$0(childPrimProperties).add(factorF);
                        }
                        break block24;
                    }
                    catch (IllegalArgumentException e) {
                        UserPropertiesHolder.access$4(VariableProperties.access$2(childProperties));
                        this.graph.removeParents(child);
                        if (!VariableProperties.access$0(childProperties).isEmpty()) {
                            this.factors.remove(VariableProperties.access$0(childProperties).getFirst());
                            VariableProperties.access$0(childProperties).clear();
                        }
                        ** for (parentFactor : VariableProperties.access$0((VariableProperties)childPrimProperties))
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.factors.remove(parentFactor);
                        continue;
                    }
lbl59:
                    // 1 sources

                    this.nameToVar.remove(childPrim.getName(false));
                    this.variableToProperties.remove(childPrim);
                    this.graph.removeNode(childPrim);
                    this.maxFactorSize = oldMaxFactorSize;
                    throw e;
                }
                if (factorF.getSize() <= this.maxFactorSize) continue;
                this.maxFactorSize = factorF.getSize();
            }
        } else {
            variablesIterator = factor.getVariables();
            index = 0;
            try {
                while (variablesIterator.hasNext()) {
                    if (index++ != ((FactorDirected)factor).getChildIndex()) {
                        this.graph.addParent(child, variablesIterator.next(), this.enforceAcylicity);
                        continue;
                    }
                    variablesIterator.next();
                }
            }
            catch (IllegalArgumentException e) {
                UserPropertiesHolder.access$4(VariableProperties.access$2(childProperties));
                this.graph.removeParents(child);
                throw e;
            }
            this.factors.add(factor);
            VariableProperties.access$0(childProperties).add(factor);
            if (factor.getSize() > this.maxFactorSize) {
                this.maxFactorSize = factor.getSize();
            }
        }
    }

    public final void addParents(VariableDecision decisionVariable, Variable[] parents, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (this.graph.getParentsNum(decisionVariable) != 0) {
            throw new IllegalArgumentException("Parents for this variable ('" + decisionVariable.getName(false) + "') are already in the network.");
        }
        try {
            this.variableToProperties.get(decisionVariable).definitionProperties.add(propertiesIterator);
        }
        catch (IllegalArgumentException e) {
            this.variableToProperties.get(decisionVariable).definitionProperties.clear();
            throw e;
        }
        try {
            int i = 0;
            while (i < parents.length) {
                this.graph.addParent(decisionVariable, parents[i], this.enforceAcylicity);
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            this.variableToProperties.get(decisionVariable).definitionProperties.clear();
            this.graph.removeParents(decisionVariable);
            throw e;
        }
    }

    public final Iterator<Factor> getFactors(boolean withUtility) {
        ItrIterator<Factor> iterator = new ItrIterator<Factor>(this.factors.iterator());
        if (!withUtility || !this.isDecisionNetwork) {
            iterator.next();
        }
        return iterator;
    }

    public final int getNumProbFactors() {
        return this.factors.size() - 1;
    }

    public final long getMaxFactorSize() {
        return this.maxFactorSize;
    }

    public final long getSize() {
        Iterator iterator = this.factors.iterator();
        long count = 0L;
        if (!this.isDecisionNetwork) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            count += ((Factor)iterator.next()).getSize();
        }
        return count;
    }

    final DNGraph getGraph() {
        return this.graph.clone();
    }

    public final Iterator<Variable> getParents(Variable child) {
        return this.graph.getParents(child);
    }

    public final int getParentsNum(Variable child) {
        return this.graph.getParentsNum(child);
    }

    public final boolean isConstructionFinished() {
        return this.constructionFinished;
    }

    public final void finishConstruction(boolean checkNoForgetting) throws Exception {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        for (Variable variable : this.variableToProperties.keySet()) {
            if (variable instanceof VariableNature) {
                if (!this.variableToProperties.get(variable).factorsList.isEmpty()) continue;
                throw new Exception("Probability distribution not specified for the random variable (" + variable.getName(false) + ").");
            }
            boolean bl = this.isPolicyDefined = this.isPolicyDefined && !this.variableToProperties.get(variable).factorsList.isEmpty();
        }
        if (this.isDecisionNetwork) {
            if (this.factors.getFirst() == null) {
                throw new Exception("Utility is not specified for the decision network.");
            }
            if (checkNoForgetting) {
                TreeSet<PairComparable<Integer, Variable>> totalOrdering = new TreeSet<PairComparable<Integer, Variable>>();
                int decisionFunctionsCount = 0;
                for (Variable variable : this.variableToProperties.keySet()) {
                    if (!(variable instanceof VariableDecision)) continue;
                    int numDecisionParents = 0;
                    Iterator<Variable> iterator = this.graph.getParents(variable);
                    while (iterator.hasNext()) {
                        if (!(iterator.next() instanceof VariableDecision)) continue;
                        ++numDecisionParents;
                    }
                    totalOrdering.add(new PairComparable<Integer, Variable>(numDecisionParents, variable));
                    if (this.variableToProperties.get(variable).factorsList.isEmpty()) continue;
                    ++decisionFunctionsCount;
                }
                int expectedNumDecisionsParents = 0;
                int score = totalOrdering.size() - decisionFunctionsCount + 1;
                Variable previousVariable = null;
                for (PairComparable pairComparable : totalOrdering) {
                    VariableProperties decisionVariableProperties;
                    Iterator<Variable> currentParentsIterator;
                    if ((Integer)pairComparable.getFirstElement() != expectedNumDecisionsParents) {
                        throw new Exception("Decision network is not a proper no-forgetting decision network.");
                    }
                    Variable decisionVariable = (Variable)pairComparable.getSecondElement();
                    if (expectedNumDecisionsParents != 0) {
                        Iterator<Object> previousParentsIterator = this.graph.getParents(previousVariable);
                        currentParentsIterator = this.graph.getParents(decisionVariable);
                        boolean previousVariabIesParent = false;
                        while (previousParentsIterator.hasNext()) {
                            Variable previousParent = previousParentsIterator.next();
                            boolean previousParentFound = false;
                            while (!previousParentFound && currentParentsIterator.hasNext()) {
                                Variable currentParent = currentParentsIterator.next();
                                previousParentFound = currentParent.equals(previousParent);
                                boolean bl = previousVariabIesParent = previousVariabIesParent || currentParent.equals(previousVariable);
                            }
                            if (previousParentFound) continue;
                            throw new Exception("Decision network is not a proper no-forgetting decision network.");
                        }
                        while (!previousVariabIesParent && currentParentsIterator.hasNext()) {
                            boolean bl = previousVariabIesParent = previousVariabIesParent || currentParentsIterator.next().equals(previousVariable);
                        }
                        if (!previousVariabIesParent) {
                            throw new Exception("Decision network is not a proper no-forgetting decision network.");
                        }
                    }
                    if ((decisionVariableProperties = this.variableProperties(decisionVariable)).factorsList.isEmpty()) {
                        currentParentsIterator = this.graph.getParents(decisionVariable);
                        while (currentParentsIterator.hasNext()) {
                            VariableProperties parentProperties = this.variableProperties(currentParentsIterator.next());
                            if (parentProperties.getDecisionHierarchyScore() != 0) continue;
                            parentProperties.decisionHierarchyScore = score;
                        }
                        decisionVariableProperties.decisionHierarchyScore = --score;
                    }
                    ++expectedNumDecisionsParents;
                    previousVariable = (Variable)pairComparable.getSecondElement();
                }
                this.isNoForgetting = true;
            }
        }
        this.constructionFinished = true;
    }

    public DecisionNetwork(Configuration configuration) {
        this.factorSavingForTracing = configuration.getFactorSavingForTracing();
        this.factorDistributionThreshold = configuration.getFactorDistributionThreshold();
        this.enforceAcylicity = configuration.getNetworkEnforceAcyclicity();
        this.factorizeNoisyFactors = configuration.getNetworkFactorizeNoisyFactors();
        this.variableToProperties = new TreeMap();
        this.factors = new LinkedList();
        this.factors.addFirst(null);
        this.nameToVar = new HashMap();
        this.graph = new DNGraph();
        this.uniqueId = nextId.getAndIncrement();
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    public String toString(boolean brief, int precision, boolean withId) {
        StringBuilder output = new StringBuilder();
        Iterator factorsIterator = this.factors.iterator();
        if (this.isDecisionNetwork) {
            output.append("Decision Network \"");
        } else {
            output.append("Belief Network \"");
            factorsIterator.next();
        }
        output.append(this.getName(withId)).append("\":\n");
        output.append("\n - variables:");
        for (Variable variable : this.variableToProperties.keySet()) {
            output.append("\n").append(variable.toString(withId));
        }
        output.append("\n\n - factors:");
        while (factorsIterator.hasNext()) {
            Factor factor = (Factor)factorsIterator.next();
            output.append("\nFactor ").append(((FactorInterpretable)((Object)factor)).getInterpretation(withId)).append(":");
            if (brief) {
                output.append(" ").append(factor.getName(withId)).append("\n");
            } else {
                output.append("\n").append(factor.toString("   ", precision, withId)).append("\n");
            }
            output.append("Size: ").append(factor.getSize()).append("\n");
        }
        output.append("\nNumber of factors: ");
        if (this.isDecisionNetwork) {
            output.append(this.factors.size());
        } else {
            output.append(this.factors.size() - 1);
        }
        output.append(".\nNumer of parameters: ").append(this.getSize()).append(".\n");
        output.append("\n - structure:\n").append(this.graph.toString(withId, false));
        if (this.isDecisionNetwork) {
            output.append("\nparents(UTILITY) = {");
            Iterator<Variable> parentsIterator = this.factors.getFirst().getVariables();
            if (parentsIterator.hasNext()) {
                output.append(parentsIterator.next().getName(withId));
            }
            while (parentsIterator.hasNext()) {
                output.append(", ").append(parentsIterator.next().getName(withId));
            }
            output.append("}");
        }
        return output.toString();
    }

    public String toString(boolean brief, boolean withId) {
        return this.toString(brief, 3, withId);
    }

    @Override
    public String toString(boolean withId) {
        return this.toString(false, 3, withId);
    }

    public String toString() {
        return this.toString(false, 3, true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Decision network has its own unique ID. It can't be cloned. Also it is virtually  immutable so there is no much point in cloning.");
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        throw new UnsupportedOperationException("DecisionNetwork class can not save \"" + decisionNetwork.getName(false) + "\" network to string. Use one of derived classes instead.");
    }

    @NotThreadSafe
    final class DNGraph
    extends Graph<Variable> {
        DNGraph() {
        }

        int markRelevant(Set<Variable> relevantVariables, Variable relevantVariable) {
            int result = 0;
            if (!relevantVariables.contains(relevantVariable)) {
                relevantVariables.add(relevantVariable);
                result = 1;
                TreeSet variableParents = (TreeSet)this.parents.get(relevantVariable);
                if (variableParents == null) {
                    throw new IllegalArgumentException("Variable '" + relevantVariable.getName(false) + "' is not in the graph.");
                }
                Iterator parentsIterator = variableParents.iterator();
                while (parentsIterator.hasNext()) {
                    result += this.markRelevant(relevantVariables, (Variable)parentsIterator.next());
                }
            }
            return result;
        }

        @Override
        public final DNGraph clone() {
            DNGraph clone = new DNGraph();
            for (Map.Entry entry : this.parents.entrySet()) {
                clone.parents.put((Variable)entry.getKey(), new TreeSet((SortedSet)entry.getValue()));
            }
            for (Map.Entry entry : this.ancestors.entrySet()) {
                clone.ancestors.put((Variable)entry.getKey(), new HashSet((Collection)entry.getValue()));
            }
            return clone;
        }
    }

    @NotThreadSafe
    public final class SamplesFactory {
        private final Random generator;
        private final Variable[] variables;
        private final Factor[] distributions;

        public final Variable[] getVariablesArray() {
            Variable[] result = new Variable[this.variables.length];
            System.arraycopy(this.variables, 0, result, 0, this.variables.length);
            return result;
        }

        private SamplesFactory(Random generator) {
            if (!DecisionNetwork.this.constructionFinished) {
                throw new UnsupportedOperationException("Decision network is not fully constructed.");
            }
            if (DecisionNetwork.this.isDecisionNetwork) {
                throw new UnsupportedOperationException("Sampling is not implemented for decision networks.");
            }
            this.generator = generator;
            LinkedList topologicalOrder = DecisionNetwork.this.graph.getTopologicalOrdering();
            this.variables = new Variable[topologicalOrder.size()];
            this.distributions = new Factor[topologicalOrder.size()];
            int i = 0;
            Iterator variablesIterator = topologicalOrder.iterator();
            while (variablesIterator.hasNext()) {
                this.variables[i] = (Variable)variablesIterator.next();
                LinkedList factorsList = DecisionNetwork.this.variableProperties(this.variables[i]).factorsList;
                if (factorsList.size() > 1) {
                    throw new UnsupportedOperationException("Sampling is not implemented for factorized conditional probability distibutions.");
                }
                this.distributions[i] = (Factor)factorsList.getFirst();
                ++i;
            }
        }

        public Object[] getSampleValues() {
            Object[] values = new Object[this.variables.length];
            HashMap<Variable, Integer> sample = this.getSampleMap();
            int i = 0;
            while (i < values.length) {
                values[i] = this.variables[i].getDomain().getValue(sample.get(this.variables[i]));
                ++i;
            }
            return values;
        }

        public int[] getSampleIndices() {
            int[] indices = new int[this.variables.length];
            HashMap<Variable, Integer> sample = this.getSampleMap();
            int i = 0;
            while (i < indices.length) {
                indices[i] = sample.get(this.variables[i]);
                ++i;
            }
            return indices;
        }

        public HashMap<Variable, Integer> getSampleMap() {
            HashMap<Variable, Integer> sample = new HashMap<Variable, Integer>();
            int indexA = 0;
            while (indexA < this.variables.length) {
                long offset = 0L;
                int indexB = 0;
                while (indexB < ((FactorDistribution)((Object)this.distributions[indexA])).getChildIndex()) {
                    offset = offset * (long)this.distributions[indexA].getVariable(indexB).getDomain().getSize() + (long)sample.get(this.distributions[indexA].getVariable(indexB)).intValue();
                    ++indexB;
                }
                offset *= (long)this.variables[indexA].getDomain().getSize();
                long blockAfter = 1L;
                int indexB2 = ((FactorDistribution)((Object)this.distributions[indexA])).getChildIndex() + 1;
                while (indexB2 < this.distributions[indexA].getVariablesNum()) {
                    int domainSize = this.distributions[indexA].getVariable(indexB2).getDomain().getSize();
                    offset = offset * (long)domainSize + (long)sample.get(this.distributions[indexA].getVariable(indexB2)).intValue();
                    blockAfter *= (long)domainSize;
                    ++indexB2;
                }
                double sampledValue = this.generator.nextDouble();
                double cumulativeProbability = 0.0;
                int sampledIndex = 0;
                while (sampledIndex < this.variables[indexA].getDomain().getSize()) {
                    if (sampledValue < (cumulativeProbability += this.distributions[indexA].getValue(offset))) break;
                    offset += blockAfter;
                    ++sampledIndex;
                }
                sample.put(this.variables[indexA], sampledIndex);
                ++indexA;
            }
            return sample;
        }
    }

    @NotThreadSafe
    public final class UserPropertiesHolder {
        private final HashMap<String, Property> properties = new HashMap();

        private UserPropertiesHolder() {
        }

        private UserPropertiesHolder(Iterator<Property> propertiesIterator) {
            if (propertiesIterator != null) {
                while (propertiesIterator.hasNext()) {
                    Property property = propertiesIterator.next();
                    if (property == null) {
                        throw new IllegalArgumentException("Null property.");
                    }
                    if (this.properties.put(property.getName(), property) == null) continue;
                    throw new IllegalArgumentException("Duplicate property '" + property.getName() + "'.");
                }
            }
        }

        private boolean add(Property property) {
            Property previous = this.properties.put(property.getName(), property);
            if (previous != null) {
                this.properties.put(previous.getName(), previous);
                return false;
            }
            return true;
        }

        private void add(Iterator<Property> propertiesIterator) {
            if (propertiesIterator != null) {
                while (propertiesIterator.hasNext()) {
                    Property property = propertiesIterator.next();
                    if (property == null) {
                        throw new IllegalArgumentException("Null property.");
                    }
                    if (this.properties.put(property.getName(), property) == null) continue;
                    throw new IllegalArgumentException("Duplicate property ('" + property.getName() + ").");
                }
            }
        }

        private void clear() {
            this.properties.clear();
        }

        public Property get(String propertyName) {
            return this.properties.get(propertyName);
        }

        public Iterator<Property> get() {
            return new ItrIterator<Property>(this.properties.values().iterator());
        }

        public int getNum() {
            return this.properties.size();
        }
    }

    @NotThreadSafe
    public final class VariableProperties {
        private final UserPropertiesHolder variableProperties;
        private final UserPropertiesHolder definitionProperties;
        private final LinkedList<Factor> factorsList;
        private int decisionHierarchyScore;

        public final UserPropertiesHolder getVariableProperties() {
            return this.variableProperties;
        }

        public final UserPropertiesHolder getDefinitionProperties() {
            return this.definitionProperties;
        }

        public final int getFactorsNum() {
            return this.factorsList.size();
        }

        public final Iterator<Factor> getFactors() {
            return new ItrIterator<Factor>(this.factorsList.iterator());
        }

        final int getDecisionHierarchyScore() {
            return this.decisionHierarchyScore;
        }

        private VariableProperties(Iterator<Property> propertiesIterator) {
            this.variableProperties = new UserPropertiesHolder(propertiesIterator);
            this.definitionProperties = new UserPropertiesHolder();
            this.factorsList = new LinkedList();
            this.decisionHierarchyScore = 0;
        }
    }
}

