/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit.dialogs;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;

public abstract class BasicFrame
extends JFrame
implements ActionListener {
    protected GridBagConstraints gbc = null;
    protected GridBagLayout gbl = null;
    private int insetSize;
    private String okString = "OK";
    private String cancelString = "Cancel";

    public BasicFrame() {
    }

    public BasicFrame(int insetSize) {
        this.setInsetSize(insetSize);
    }

    public BasicFrame(String title) {
        super(title);
    }

    public BasicFrame(String title, int insetSize) {
        super(title);
        this.setInsetSize(insetSize);
    }

    protected final void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        if (this.gbc == null || this.gbl == null) {
            return;
        }
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    private void setInsetSize(int size) {
        this.insetSize = this.insetSize < 0 ? 0 : size;
    }

    protected final void packCenterOpen() {
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    protected final void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        this.setLocation(centerPosition.x - windowSize.width / 2, centerPosition.y - windowSize.height / 2);
    }

    protected final void ensureOnScreen(AIspace.graphToolKit.elements.Point loc) {
        if (loc != null) {
            int x = (int)loc.x;
            int y = (int)loc.y;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (x + this.getSize().width > screenSize.width) {
                x = screenSize.width - this.getSize().width;
            }
            if (y + this.getSize().height > screenSize.height) {
                y = screenSize.height - this.getSize().height - 60;
            }
            this.setLocation(x, y);
        } else {
            this.centerWindow();
        }
    }

    protected final void setOKString(String okString) {
        this.okString = okString;
    }

    protected final void setCancelString(String cancelString) {
        this.cancelString = cancelString;
    }

    public final Insets getInsets() {
        Insets ins = (Insets)super.getInsets().clone();
        ins.left += this.insetSize;
        ins.right += this.insetSize;
        ins.bottom += this.insetSize;
        ins.top += this.insetSize;
        return ins;
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand().trim();
        if (arg.equalsIgnoreCase(this.okString)) {
            if (this.actionOK()) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (arg.equalsIgnoreCase(this.cancelString) && this.actionCancel()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    protected abstract boolean actionOK();

    protected abstract boolean actionCancel();
}

