/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit;

import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.InlineApplet;
import AIspace.graphToolKit.dialogs.EdgeDialog;
import AIspace.graphToolKit.dialogs.FontDialog;
import AIspace.graphToolKit.dialogs.MessageDialog;
import AIspace.graphToolKit.dialogs.MessageFrame;
import AIspace.graphToolKit.dialogs.NodeDialog;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.EdgeLabel;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GraphCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
Printable,
KeyListener,
ActionListener {
    public Container parent;
    public Graph graph;
    public int WIDTH;
    public int HEIGHT;
    protected Font font;
    protected Point mClickedPos;
    protected Point mDraggedPos;
    protected Point mMovedPos;
    protected Point mPressedPos;
    protected Point mReleasedPos;
    protected Point mOriginalPos;
    protected boolean isDragging;
    protected boolean isMoving;
    protected boolean isClicked;
    protected boolean isSelected;
    protected Entity hover;
    protected Node from;
    protected Node to;
    protected int makingEdge;
    protected static final int NO = 0;
    protected static final int YES = 1;
    protected static final int DONE = 2;
    protected int submode;
    protected int mode;
    protected int rmode;
    public int tempMode;
    protected int tmpMode;
    protected NodeDialog nDialog;
    protected EdgeDialog eDialog;
    protected float[] panZoomRect;
    public boolean pause = true;
    public boolean inline;
    public JPopupMenu pop;
    protected MessageDialog md;
    protected MessageFrame mf;
    protected Entity entClicked;
    protected Entity tempEnt;
    protected float draggingDifX;
    protected float draggingDifY;

    public GraphCanvas(Container parent, boolean inline) {
        this.parent = parent;
        this.inline = inline;
        this.graph = new Graph(this);
        this.init();
    }

    public void init() {
        this.font = new Font("SansSerif", 0, 12);
        this.mode = 2220;
        this.submode = 3332;
        this.rmode = 4441;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setBackground(Color.white);
        this.panZoomRect = new float[4];
        this.clearMouse();
        this.pause = false;
        this.pop = new JPopupMenu();
        this.add(this.pop);
        this.tmpMode = -1;
        this.setCanvasSize();
        this.setVisible(true);
    }

    protected void popupCanvas(int x, int y) {
        JMenuItem mItem;
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Canvas Options"));
        if (this.mode == 2220) {
            mItem = new JMenuItem("Create Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.addSeparator();
        }
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Reset Edge Labels");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        if (this.mode == 2221) {
            this.popupCanvas(x, y);
            return;
        }
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        JMenuItem mItem = new JMenuItem("Create Edge");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Set Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Node");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Edge Options"));
        JMenuItem mItem = new JMenuItem("Set Properties");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Reset Edge Label");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        mItem = new JMenuItem("Delete Edge");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.addSeparator();
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    public void setCanvasSize() {
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
    }

    public void reset() {
        this.graph = new Graph(this);
        this.clearMouse();
        this.repaint();
    }

    public void showMessage(String title, String msg) {
        this.pause();
        if (this.inline) {
            if (this.mf == null) {
                this.mf = new MessageFrame();
                this.mf.addActionListener(this);
            }
            this.mf.open(title, msg);
        } else {
            this.md = new MessageDialog((JFrame)this.parent);
            this.md.addActionListener(this);
            this.md.open(title, msg);
        }
        this.unpause();
    }

    public void clearMouse() {
        this.isDragging = false;
        this.isMoving = false;
        this.isClicked = false;
        this.isSelected = false;
        this.mClickedPos = new Point();
        this.mDraggedPos = new Point();
        this.mMovedPos = new Point();
        this.mPressedPos = new Point();
        this.mReleasedPos = new Point();
        this.mOriginalPos = new Point();
        this.makingEdge = 0;
        this.from = null;
        this.to = null;
        this.panZoomRect[0] = 0.0f;
        this.panZoomRect[1] = 0.0f;
        this.panZoomRect[2] = 0.0f;
        this.panZoomRect[3] = 0.0f;
        this.entClicked = null;
    }

    public void setGraph(Graph graph) {
        this.clearMouse();
        this.graph = graph;
        this.moveGraphToMiddle();
        this.zoom(this.maximizingScale());
    }

    public void moveGraphToPoint(Point point) {
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        this.graph.translateAll(point.x - midX, point.y - midY);
    }

    public void changeFont(int size) {
        if (size == -1) {
            new FontDialog(this);
        } else {
            this.font = new Font("SansSerif", 0, size);
            ((GraphWindow)this.parent).setMessageCanvasFontSize(size);
        }
        this.graph.updateNodeSize();
        this.graph.updateEdgeSize();
        this.repaint();
    }

    public int getFontSize() {
        return this.font.getSize();
    }

    public void centerOverNode(Node node) {
        if (node == null) {
            return;
        }
        if (!this.inline) {
            Rectangle windowBounds = ((GraphWindow)this.parent).scrollPanel.getBounds();
            ((GraphWindow)this.parent).setHorizontalBarPosition((int)node.pos.x - windowBounds.width / 2);
            ((GraphWindow)this.parent).setVerticalBarPosition((int)node.pos.y - windowBounds.height / 2);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.font);
    }

    public FontMetrics getFontMetricsForPrinting() {
        return this.getFontMetrics(new Font("sans serif", 0, 9));
    }

    public void updateGraph() {
        this.graph.updateNodeSize();
        this.graph.updateEdgeSize();
        this.repaint();
    }

    public void changeLineWidth() {
        this.graph.updateNodeSize();
        this.repaint();
    }

    public void resetLabels() {
        this.graph.resetLabels();
        this.repaint();
    }

    public int getSubmode() {
        return this.submode;
    }

    public int getMode() {
        return this.mode;
    }

    public String getPromptLabel() {
        if (!this.inline) {
            return ((GraphWindow)this.parent).getPromptLabel();
        }
        return ((InlineApplet)this.parent).getPromptLabel();
    }

    public void setPromptLabel(String s) {
        if (!this.inline) {
            ((GraphWindow)this.parent).setPromptLabel(s);
        } else {
            ((InlineApplet)this.parent).setPromptLabel(s);
        }
    }

    public final void setPromptColor(Color col) {
        if (!this.inline) {
            ((GraphWindow)this.parent).setPromptColor(col);
        }
    }

    protected float maximizingScale() {
        float visibleHeight;
        float visibleWidth;
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        if (!this.inline) {
            visibleWidth = ((GraphWindow)this.parent).scrollPanel.getWidth();
            visibleHeight = ((GraphWindow)this.parent).scrollPanel.getHeight();
        } else {
            visibleWidth = ((InlineApplet)this.parent).getCanvas().getWidth();
            visibleHeight = ((InlineApplet)this.parent).getCanvas().getHeight();
        }
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = visibleWidth / graphWidth;
        float heightRatio = visibleHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    public float maximizingScaleForPrinting() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        float printingWidth = 450.0f;
        float printingHeight = 400.0f;
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = printingWidth / graphWidth;
        float heightRatio = printingHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    public void zoom(float scale) {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        this.graph.setScale(scale);
        this.moveGraphToPoint(new Point(midX, midY));
        this.repaint();
    }

    public void zoom(Point point, float scale) {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        double hRatio = (point.x - min.x) / Math.abs(max.x - min.x);
        double vRatio = (point.y - min.y) / Math.abs(max.y - min.y);
        this.graph.setScale(scale);
        min = this.graph.getBound()[0];
        max = this.graph.getBound()[1];
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        float newX = min.x + (float)((double)(max.x - min.x) * hRatio);
        float newY = min.y + (float)((double)(max.y - min.y) * vRatio);
        midX += newX - midX;
        midY += newY - midY;
        this.graph.translateAll(point.x - midX, point.y - midY);
        this.repaint();
    }

    public void zoomForPrinting() {
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        this.graph.setScale(this.maximizingScaleForPrinting());
        this.moveGraphToPoint(new Point(300.0f, 275.0f));
    }

    public void moveGraphToMiddle() {
        float middleY;
        float middleX;
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        if (!this.inline) {
            middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
            middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        } else {
            middleX = ((InlineApplet)this.parent).getCanvas().getWidth() / 2;
            middleY = ((InlineApplet)this.parent).getCanvas().getHeight() / 2;
        }
        this.graph.translateAll(middleX - midX, middleY - midY);
    }

    public void moveToTopMiddle() {
        float middleY;
        float middleX;
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        if (!this.inline) {
            middleX = ((GraphWindow)this.parent).scrollPanel.getHorizontalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getWidth() / 2;
            middleY = ((GraphWindow)this.parent).scrollPanel.getVerticalScrollBar().getValue() + ((GraphWindow)this.parent).scrollPanel.getHeight() / 2;
        } else {
            middleX = ((InlineApplet)this.parent).getCanvas().getWidth() / 2;
            middleY = ((InlineApplet)this.parent).getCanvas().getHeight() / 2;
        }
        this.graph.translateAll(middleX - midX, middleY + 40.0f);
    }

    public void autoscale() {
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.moveGraphToMiddle();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawPrint((Graphics2D)g);
    }

    public boolean isAntiAliasingEnabled() {
        return ((GraphWindow)this.parent).isAntiAliasingEnabled();
    }

    public void drawPrint(Graphics2D g2) {
        if (this.isAntiAliasingEnabled()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setColor(Color.black);
        if (this.isDragging && !this.isMoving && this.mode != 2221) {
            g2.drawRect((int)Math.min(this.mPressedPos.x, this.mDraggedPos.x), (int)Math.min(this.mPressedPos.y, this.mDraggedPos.y), (int)Math.abs(this.mPressedPos.x - this.mDraggedPos.x), (int)Math.abs(this.mPressedPos.y - this.mDraggedPos.y));
        }
        if (this.makingEdge == 1 || this.makingEdge == 2) {
            g2.drawLine((int)this.from.pos.x, (int)this.from.pos.y, (int)this.mMovedPos.x, (int)this.mMovedPos.y);
        }
        this.graph.draw(g2, this.isMoving);
    }

    public void setSubmode(int newMode) {
        this.submode = newMode;
        this.tempMode = 0;
        this.clearMouse();
        this.graph.deselectAll();
        this.repaint();
    }

    public void checkAndResetSubMode(Entity ent) {
        if (ent != this.tempEnt && this.tempMode != 0) {
            this.submode = this.tempMode;
        }
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        this.clearMouse();
        this.graph.deselectAll();
    }

    public void setRMode(int newMode) {
        this.rmode = newMode;
    }

    public int getRMode() {
        return this.rmode;
    }

    public void pause() {
        this.pause = true;
    }

    public void unpause() {
        this.pause = false;
    }

    public void disposeWindows() {
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
        if (this.md != null) {
            this.md.dispose();
        }
        if (this.mf != null) {
            this.mf.dispose();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.pause) {
            return;
        }
        if (this.entClicked != null) {
            this.entClicked.isBold = false;
        }
        Point p = new Point(e.getX(), e.getY());
        this.mClickedPos = new Point(p);
        this.entClicked = this.graph.searchEntities(p);
        if (e.getModifiers() == 4) {
            this.isSelected = this.graph.deselectAll();
            if (this.hover != null) {
                this.hover.isBold = false;
            }
            if (this.makingEdge == 1) {
                this.makingEdge = 0;
                this.submode = this.tmpMode;
                return;
            }
            if (this.entClicked == null) {
                this.popupCanvas(e.getX(), e.getY());
            } else {
                this.entClicked.isBold = true;
                this.isClicked = true;
                this.isSelected = this.graph.select(this.entClicked);
                if (this.entClicked.type == 7770) {
                    this.popupNode(e.getX(), e.getY());
                } else if (this.entClicked.type == 7771) {
                    this.popupEdge(e.getX(), e.getY());
                } else if (this.entClicked.type == 7772) {
                    this.entClicked.isBold = false;
                    this.entClicked = ((EdgeLabel)this.entClicked).parent;
                    this.isClicked = true;
                    this.isSelected = this.graph.deselectAll();
                    this.isSelected = this.graph.select(this.entClicked);
                    this.popupEdge(e.getX(), e.getY());
                }
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        if (this.pause) {
            return;
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        block20: {
            Entity ent;
            block19: {
                if (this.pause) {
                    return;
                }
                this.requestFocus();
                Point p = new Point(e.getX(), e.getY());
                ent = this.graph.searchEntities(p);
                this.mPressedPos.move(p);
                this.mDraggedPos.move(p);
                this.mOriginalPos.move(p);
                if (e.getModifiers() == 4) {
                    return;
                }
                if (ent == null && !e.isControlDown() && !e.isShiftDown()) {
                    this.graph.deselectAll();
                    if (this.pop.isVisible()) {
                        this.pop.setVisible(false);
                        return;
                    }
                }
                if (this.mode != 2220) break block19;
                switch (this.submode) {
                    case 3330: {
                        this.createNode(ent, p);
                        break;
                    }
                    case 3331: {
                        this.createEdge(ent, p);
                        break;
                    }
                    case 3332: {
                        this.mPressedSelect(ent, e.isControlDown() || e.isShiftDown());
                        break;
                    }
                    case 3333: {
                        if (ent != null) {
                            this.undo();
                            this.deleteEnt(ent);
                            break;
                        }
                        break block20;
                    }
                    case 3334: {
                        if (ent != null) {
                            this.setEntProperties(ent);
                            break;
                        }
                        break block20;
                    }
                    case 3335: {
                        if (this.tempEnt != null && ent == this.tempEnt) {
                            this.mPressedSelect(ent, false);
                            break;
                        }
                        if (this.tempMode == 0) break block20;
                        this.submode = this.tempMode;
                        this.tempMode = 0;
                        this.tempEnt = null;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block20;
            }
            if (this.mode == 2221) {
                this.mPressedSelect(ent, false);
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.pause) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        this.mReleasedPos.move(p);
        if (e.getModifiers() != 4) {
            if (this.mode == 2220) {
                if (this.submode == 3332 || this.submode == 3335) {
                    this.mReleasedSelect(ent, e.isControlDown() || e.isShiftDown());
                }
            } else if (this.mode == 2221) {
                this.graph.deselectAll();
            }
        }
        if (this.tempMode != 0 && (this.submode == 3332 || this.submode == 3335)) {
            this.submode = this.tempMode;
            this.tempMode = 0;
            this.tempEnt = null;
        }
        this.isDragging = false;
        this.isMoving = false;
        this.mDraggedPos.move(0.0f, 0.0f);
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.pause) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4) {
            if (!this.isDragging) {
                if (Math.abs(this.mPressedPos.x - p.x) > 5.0f || Math.abs(this.mPressedPos.y - p.y) > 5.0f) {
                    this.isDragging = true;
                    this.isMoving = true;
                }
                this.repaint();
                return;
            }
            float dx = p.x - this.mPressedPos.x;
            float dy = p.y - this.mPressedPos.y;
            if (this.rmode == 4440) {
                this.graph.translateAll(dx, dy);
            } else if (this.rmode == 4441) {
                float scale = this.graph.getScale() * (1.0f - dy / 100.0f);
                if ((double)scale < 0.1) {
                    scale = 0.1f;
                }
                this.zoom(this.mOriginalPos, scale);
            }
            this.mPressedPos.x = p.x;
            this.mPressedPos.y = p.y;
        } else if (this.submode != 3333) {
            this.mDraggedSelect();
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.pause) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (this.hover != null && (ent == null || ent != this.hover)) {
            this.hover.isBold = false;
            this.hover = null;
        } else if (this.hover != ent) {
            this.hover = ent;
            this.hover.isBold = true;
        }
        if (this.submode == 3331 && this.makingEdge == 1) {
            this.mMovedPos.move(p);
        }
        this.repaint();
    }

    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent.type != 7770 && ent.type != 7771 && ent.type != 7772) {
            this.pause();
            if (this.nDialog == null) {
                this.nDialog = new NodeDialog(this);
            }
            this.nDialog.open(p);
            this.unpause();
        }
    }

    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.pause();
                this.makingEdge = 2;
                this.to = (Node)ent;
                if (this.eDialog == null) {
                    this.eDialog = new EdgeDialog(this);
                }
                this.eDialog.open(this.from, this.to);
                this.unpause();
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (Node)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            this.pause();
            switch (ent.type) {
                case 7770: {
                    if (this.nDialog == null) {
                        this.nDialog = new NodeDialog(this);
                    }
                    this.nDialog.open((Node)ent);
                    this.graph.updateNodeSize((Node)ent);
                    break;
                }
                case 7771: {
                    if (this.eDialog == null) {
                        this.eDialog = new EdgeDialog(this);
                    }
                    this.eDialog.open((Edge)ent);
                    break;
                }
                case 7772: {
                    if (this.eDialog == null) {
                        this.eDialog = new EdgeDialog(this);
                    }
                    this.eDialog.open(((EdgeLabel)ent).parent);
                }
            }
            this.unpause();
        }
    }

    protected void undo() {
    }

    protected void deleteEnt(Entity ent) {
        if (ent != null) {
            if (ent.type == 7772) {
                this.graph.select(((EdgeLabel)ent).parent);
            } else {
                this.graph.select(ent);
            }
            this.graph.deleteSelected();
            this.isSelected = false;
            this.isClicked = false;
        }
    }

    protected void mPressedSelect(Entity ent, boolean shiftOrCtrl) {
        if (ent != null) {
            if (!shiftOrCtrl && !ent.isSelected) {
                this.isSelected = this.graph.deselectAll();
            }
            this.isClicked = ent.isSelected;
            this.isSelected = this.graph.select(ent);
            if (this.isClicked && ent.type != 7771) {
                this.isMoving = true;
            }
        }
        this.repaint();
    }

    protected void mReleasedSelect(Entity ent, boolean shiftOrCtrl) {
        if (this.isDragging) {
            if (!this.isMoving) {
                float x1 = Math.min(this.mPressedPos.x, this.mReleasedPos.x);
                float y1 = Math.min(this.mPressedPos.y, this.mReleasedPos.y);
                float w = Math.abs(this.mPressedPos.x - this.mReleasedPos.x);
                float h = Math.abs(this.mPressedPos.y - this.mReleasedPos.y);
                Point a = new Point(x1, y1);
                Point b = new Point(x1 + w, y1 + h);
                ArrayList<Entity> selectedEntities = this.graph.searchEntities(a, b);
                if (!shiftOrCtrl) {
                    this.isSelected = this.graph.deselectAll();
                }
                int i = 0;
                while (i < selectedEntities.size()) {
                    this.isSelected = this.graph.select(selectedEntities.get(i));
                    ++i;
                }
            }
        } else if (ent != null) {
            if (shiftOrCtrl) {
                if (this.isClicked) {
                    this.isSelected = this.graph.deselect(ent);
                }
            } else {
                this.isSelected = this.graph.deselectAllButThis(ent);
            }
        }
        this.repaint();
    }

    protected void mDraggedSelect() {
        if (!this.isDragging) {
            if (Math.abs(this.mPressedPos.x - this.mDraggedPos.x) > 5.0f || Math.abs(this.mPressedPos.y - this.mDraggedPos.y) > 5.0f) {
                this.isDragging = true;
                if (this.hover != null && this.hover.type == 7770) {
                    this.graph.moveNodeToTop((Node)this.hover);
                    this.draggingDifX = ((Node)this.hover).getPos().x - this.mPressedPos.x;
                    this.draggingDifY = ((Node)this.hover).getPos().y - this.mPressedPos.y;
                }
            }
            return;
        }
        if (this.hover != null && this.hover.type != 7771) {
            if (this.isMoving) {
                switch (this.hover.type) {
                    case 7770: {
                        float offsetX = this.mDraggedPos.x + this.draggingDifX;
                        float offsetY = this.mDraggedPos.y + this.draggingDifY;
                        Point point = new Point(offsetX, offsetY);
                        this.graph.moveEntities(point, (Node)this.hover);
                        break;
                    }
                    case 7772: {
                        this.graph.moveLabel(this.mDraggedPos, (EdgeLabel)this.hover);
                    }
                }
            } else if (this.isSelected) {
                this.isDragging = true;
                this.isMoving = true;
            }
        }
        this.repaint();
    }

    public void keyPressed(KeyEvent e) {
        if (this.pause || this.mode == 2221) {
            return;
        }
        int arg = e.getKeyCode();
        if (arg == 127) {
            this.graph.deleteSelected();
        } else if (arg == 27) {
            this.makingEdge = 0;
            this.submode = this.tmpMode;
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        this.aPerformed(e);
        this.repaint();
    }

    protected void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("msgBoxClosed")) {
            this.unpause();
        } else if (this.pause) {
            return;
        }
        if (arg.equals("Create Node")) {
            this.createNode(this.entClicked, this.mClickedPos);
        } else if (arg.equals("Create Edge")) {
            this.createEdge(this.entClicked, this.mClickedPos);
            if (this.tmpMode <= 0) {
                this.tmpMode = this.submode;
            }
            this.submode = 3331;
        } else if (arg.startsWith("Set Properties")) {
            if (this.tempMode == 0) {
                this.tempMode = this.submode;
            }
            this.submode = 3334;
            this.setEntProperties(this.entClicked);
            this.submode = this.tempMode;
        } else if (arg.startsWith("Delete")) {
            if (this.tempMode == 0) {
                this.tempMode = this.submode;
            }
            this.submode = 3333;
            this.deleteEnt(this.entClicked);
            this.submode = this.tempMode;
        } else {
            if (arg.startsWith("Select")) {
                this.tempEnt = this.entClicked;
                if (this.tempMode == 0) {
                    this.tempMode = this.submode;
                }
                this.submode = 3332;
                return;
            }
            if (arg.equals("Autoscale")) {
                this.autoscale();
            } else if (arg.equals("Reset Edge Labels")) {
                this.resetLabels();
            } else if (arg.equals("Reset Edge Label")) {
                this.graph.resetLabel((Edge)this.entClicked);
            } else if (arg.equals("Pan")) {
                this.setRMode(4440);
                if (!this.inline) {
                    ((GraphWindow)this.parent).setPanZoom(1);
                    ((GraphWindow)this.parent).setPromptLabel("Drag the right mouse button to pan the graph.");
                }
            } else if (arg.equals("Zoom")) {
                this.setRMode(4441);
                if (!this.inline) {
                    ((GraphWindow)this.parent).setPanZoom(0);
                    ((GraphWindow)this.parent).setPromptLabel("Drag the right mouse button up to zoom in and down to zoom out.");
                }
            }
        }
        this.graph.deselectAll();
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        return 0;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

