/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes;

import AIspace.bayes.BayesCanvas;
import AIspace.bayes.BayesWindow;
import AIspace.bayes.InlineBayesApplet;
import AIspace.bayes.elements.BayesEdge;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorCPT;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.FactorUtility;
import org.AIspace.ve.Inference;
import org.AIspace.ve.Policy;
import org.AIspace.ve.PolicyCompute;
import org.AIspace.ve.Query;
import org.AIspace.ve.QueryCompute;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.VariableNature;
import org.AIspace.ve.domains.DomainStored;
import org.AIspace.ve.parsers.BIFv0_10.DecisionNetworkFromBIFv0_10;
import org.AIspace.ve.parsers.XMLBIFv0_3.DecisionNetworkFromXMLBIFv0_3;
import org.AIspace.ve.parsers.factors.DecisionNetworkFromFactors;
import org.AIspace.ve.properties.Property;
import org.AIspace.ve.properties.PropertyGeneric;
import org.AIspace.ve.properties.PropertyPosition;
import org.AIspace.ve.tools.Pair;
import org.AIspace.ve.tools.Triple;

public class BayesGraph
extends Graph {
    public static final int BRIEF_QUERY = 8880;
    public static final int VERBOSE_QUERY = 8881;
    public static final int PROMPT_QUERY = 8882;
    private String name;
    private LinkedList<Property> graphProperties;
    private int numDecimalsToMonitor;
    private DecisionNetwork decisionNetwork;
    private Configuration config;
    private String shortDescription = "";
    private String detailedDescription = "";

    public BayesGraph(BayesCanvas canvas) {
        super(canvas);
        this.name = "Untitled";
        this.graphProperties = new LinkedList();
        this.numDecimalsToMonitor = 2;
        this.decisionNetwork = null;
        this.config = new Configuration();
    }

    public BayesGraph(BayesCanvas canvas, String textRep, int fileFormat, ArrayList<BayesNode> observedNodes) {
        super(canvas);
        this.name = "Untitled";
        this.graphProperties = new LinkedList();
        this.numDecimalsToMonitor = 2;
        this.config = new Configuration();
        this.updateFromText(textRep, fileFormat);
        if (observedNodes == null) {
            return;
        }
        for (BayesNode curNode : observedNodes) {
            BayesNode graphNode = this.getNode(curNode.getLabel());
            graphNode.setObservation(curNode.getObservation());
        }
    }

    public BayesGraph(BayesCanvas canvas, ArrayList<BayesNode> observedNodes, DecisionNetwork network) {
        super(canvas);
        this.graphProperties = new LinkedList();
        this.numDecimalsToMonitor = 2;
        this.decisionNetwork = network;
        this.config = new Configuration();
        try {
            this.parse(network);
        }
        catch (Exception e) {
            this.showMessage("Error", e.getLocalizedMessage());
        }
        if (observedNodes == null) {
            return;
        }
        for (BayesNode curNode : observedNodes) {
            BayesNode graphNode = this.getNode(curNode.getLabel());
            graphNode.setObservation(curNode.getObservation());
        }
    }

    protected void addNoForgettingArcs() {
        if (this.getUtilityNodes().size() == 0) {
            this.showMessage("Error", "The network needs a Utility node before no-forgetting arcs can be added.");
            return;
        }
        ArrayList<BayesNode> orderedDecisionNodes = this.getDecisionNodesOrdered();
        if (orderedDecisionNodes == null) {
            ((BayesCanvas)this.canvas).showMessage("Error", "Multiple total orders for decision nodes in graph.", "To have the applet automatically add no-forgetting arcs, there must be a single total order to the graph.");
            return;
        }
        int i = 1;
        while (i < orderedDecisionNodes.size()) {
            this.addNoForgettingArcs(orderedDecisionNodes.get(i), orderedDecisionNodes);
            ++i;
        }
        if (this.canvas.inline) {
            ((InlineBayesApplet)this.canvas.parent).setQueryButtons(true);
        } else {
            ((BayesWindow)this.canvas.parent).setQueryButtons(true);
        }
        this.buildDecisionNetwork();
        this.canvas.repaint();
    }

    private void addNoForgettingArcs(BayesNode curNode, ArrayList<BayesNode> orderedNodes) {
        if (curNode.getNodeType() != 7778) {
            return;
        }
        for (BayesNode node : orderedNodes) {
            if (curNode.equals(node)) {
                return;
            }
            if (this.getEdge(node.getIndex(), curNode.index) == null) {
                curNode.addParent(node);
                node.addChild(curNode);
                this.addEdge(new BayesEdge(this, node, curNode, true));
            }
            for (BayesNode parentNode : node.getParents()) {
                if (this.getEdge(parentNode.getIndex(), curNode.index) != null) continue;
                curNode.addParent(parentNode);
                parentNode.addChild(curNode);
                this.addEdge(new BayesEdge(this, parentNode, curNode, true));
            }
        }
    }

    protected void buildDecisionNetwork() {
        try {
            BayesNode curNode;
            int numFactor = 0;
            int numDecision = 0;
            String title = this.name.trim().equals("") ? "Untitled" : this.name;
            Property shortDes = null;
            Property detailedDes = null;
            for (Property prop : this.graphProperties) {
                if (!(prop instanceof PropertyGeneric)) continue;
                if (((PropertyGeneric)prop).getName().equals("short")) {
                    shortDes = prop;
                }
                if (!((PropertyGeneric)prop).getName().equals("detailed")) continue;
                detailedDes = prop;
            }
            if (shortDes != null) {
                this.graphProperties.remove(shortDes);
            }
            if (detailedDes != null) {
                this.graphProperties.remove(detailedDes);
            }
            this.graphProperties.add(new PropertyGeneric("short", this.getShortDesc()));
            this.graphProperties.add(new PropertyGeneric("detailed", this.getDetailedDesc()));
            Pair[] variables = new Pair[this.numNodes()];
            int count = 0;
            while (count < this.numNodes()) {
                curNode = (BayesNode)this.nodeAt(count);
                if (curNode.getNodeType() == 7777) {
                    variables[count] = new Pair<VariableNature, Iterator<Property>>(new VariableNature(curNode.getLabel(), new DomainStored<String>(curNode.getDomain().toArray(new String[curNode.getDomain().size()]), String.class, false)), curNode.getVariableProperties(true));
                    ++numFactor;
                } else if (curNode.getNodeType() == 7778) {
                    variables[count] = new Pair<VariableDecision, Iterator<Property>>(new VariableDecision(curNode.getLabel(), new DomainStored<String>(curNode.getDomain().toArray(new String[curNode.getDomain().size()]), String.class, false)), curNode.getVariableProperties(true));
                    if (curNode.getDecisionFunction() == null) {
                        ++numDecision;
                    } else {
                        ++numFactor;
                    }
                }
                ++count;
            }
            Pair[] factors = new Pair[numFactor];
            Triple[] parents = new Triple[numDecision];
            Pair<FactorUtility, Iterator<Property>> utility = null;
            int factorCount = 0;
            int parentCount = 0;
            int[] mapping = this.numNodes() == 0 ? new int[]{} : new int[((Node)this.nodes.get(this.numNodes() - 1)).getIndex() + 1];
            int i = 0;
            while (i < this.numNodes()) {
                mapping[((Node)this.nodes.get((int)i)).getIndex()] = i;
                ++i;
            }
            int offset = 0;
            int count2 = 0;
            while (count2 < this.numNodes()) {
                Variable[] parentVariables;
                curNode = (BayesNode)this.nodeAt(count2);
                if (curNode.getNodeType() == 7777) {
                    Variable[] factorVariables = new Variable[curNode.getParents().size() + 1];
                    int count22 = 0;
                    while (count22 < factorVariables.length - 1) {
                        factorVariables[count22] = (Variable)variables[mapping[curNode.getParents().get(count22).getIndex()]].getFirstElement();
                        ++count22;
                    }
                    factorVariables[factorVariables.length - 1] = (Variable)variables[count2 - offset].getFirstElement();
                    factors[factorCount] = new Pair<FactorCPT, Iterator<Property>>(new FactorCPT(factorVariables, true, factorVariables.length - 1, curNode.flattenProbabilities(), true, this.config.getFactorDistributionThreshold()), curNode.getDefinitionProperties(false));
                    ++factorCount;
                } else if (curNode.getNodeType() == 7778) {
                    if (curNode.getDecisionFunction() == null) {
                        parentVariables = new Variable[curNode.getParents().size()];
                        int count23 = 0;
                        while (count23 < parentVariables.length) {
                            parentVariables[count23] = (Variable)variables[mapping[curNode.getParents().get(count23).getIndex()]].getFirstElement();
                            ++count23;
                        }
                        parents[parentCount] = new Triple<VariableDecision, Variable[], Iterator<Property>>((VariableDecision)variables[count2 - offset].getFirstElement(), parentVariables, curNode.getDefinitionProperties(false));
                        ++parentCount;
                    } else {
                        parentVariables = new Variable[curNode.getParents().size()];
                        int count24 = 0;
                        while (count24 < parentVariables.length) {
                            parentVariables[count24] = (Variable)variables[mapping[curNode.getParents().get(count24).getIndex()]].getFirstElement();
                            ++count24;
                        }
                        int numActions = curNode.getDecisionFunction().getDecisionFunctionSize();
                        int[] actions = new int[numActions];
                        int count25 = 0;
                        while (count25 < numActions) {
                            actions[count25] = curNode.getDecisionFunction().getDecisionFunctionValue(count25);
                            ++count25;
                        }
                        factors[factorCount] = new Pair<FactorDecision, Iterator<Property>>(new FactorDecision(parentVariables, (VariableDecision)variables[count2 - offset].getFirstElement(), actions, false), curNode.getDefinitionProperties(false));
                        ++factorCount;
                    }
                } else {
                    parentVariables = new Variable[curNode.getParents().size()];
                    int count26 = 0;
                    while (count26 < parentVariables.length) {
                        parentVariables[count26] = (Variable)variables[mapping[curNode.getParents().get(count26).getIndex()]].getFirstElement();
                        ++count26;
                    }
                    utility = new Pair<FactorUtility, Iterator<Property>>(new FactorUtility(parentVariables, true, curNode.flattenProbabilities(), true, curNode.getLabel()), curNode.getDefinitionProperties(true));
                    Pair[] newVariables = new Pair[variables.length - 1];
                    int count27 = 0;
                    while (count27 < newVariables.length) {
                        if (variables[count27] == null) {
                            offset = 1;
                        }
                        newVariables[count27] = variables[count27 + offset];
                        ++count27;
                    }
                    variables = newVariables;
                }
                ++count2;
            }
            this.decisionNetwork = new DecisionNetworkFromFactors(title, variables, factors, parents, utility, this.graphProperties.iterator(), this.config);
        }
        catch (Exception e) {
            if (this.canvas.inline) {
                ((InlineBayesApplet)this.canvas.parent).setQueryButtons(false);
            } else {
                ((BayesWindow)this.canvas.parent).setQueryButtons(false);
            }
            this.showMessage("Error", e.getLocalizedMessage());
            this.decisionNetwork = null;
        }
    }

    protected int getQueryMode() {
        return ((BayesCanvas)this.canvas).getQueryMode();
    }

    @Override
    public void deleteSelected() {
        for (Edge curEdge : this.selectedEdges) {
            curEdge.removeFromNodes();
            this.edges.remove(curEdge);
            ((BayesNode)curEdge.start).removeChild((BayesNode)curEdge.end);
            ((BayesNode)curEdge.end).removeParent((BayesNode)curEdge.start);
        }
        this.selectedEdges.clear();
        for (BayesNode curNode : this.selectedNodes) {
            Edge curEdge;
            ArrayList<Edge>[] connected = curNode.getAllEdges();
            while (connected[0].size() > 0) {
                curEdge = connected[0].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            while (connected[1].size() > 0) {
                curEdge = connected[1].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            this.nodes.remove(curNode);
            curNode.removeNodeAsParent();
        }
        this.selectedNodes.clear();
    }

    public void setNumDecimalPlaces(int n) {
        if (n >= 1 && n <= 5) {
            this.numDecimalsToMonitor = n;
        } else if (n < 1) {
            this.numDecimalsToMonitor = 1;
        } else if (n > 5) {
            this.numDecimalsToMonitor = 5;
        }
        Iterator<BayesNode> itr = this.getMonitoredNodes().iterator();
        while (itr.hasNext()) {
            itr.next().setHistogramProbabilities(this.numDecimalsToMonitor);
        }
        this.repaint();
    }

    public int getNumDecimalsToMonitor() {
        return this.numDecimalsToMonitor;
    }

    public DecisionNetwork getDecisionNetwork() {
        return this.decisionNetwork;
    }

    public boolean isDecisionNetwork(boolean buildNetwork) {
        if (buildNetwork) {
            this.buildDecisionNetwork();
        }
        if (this.decisionNetwork != null) {
            return this.decisionNetwork.isDecisionNetwork();
        }
        return false;
    }

    public String getShortDesc() {
        return this.shortDescription;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }

    public BayesNode getNode(String nodeName) {
        for (BayesNode curNode : this.nodes) {
            if (!curNode.getLabel().equals(nodeName)) continue;
            return curNode;
        }
        return null;
    }

    private ArrayList<BayesNode> getNodes(int type) {
        ArrayList<BayesNode> nodeList = new ArrayList<BayesNode>(5);
        for (BayesNode curNode : this.nodes) {
            if (curNode.getNodeType() != type) continue;
            nodeList.add(curNode);
        }
        return nodeList;
    }

    public ArrayList<BayesNode> getAllNodes() {
        ArrayList<BayesNode> arrNodes = new ArrayList<BayesNode>(this.nodes.size());
        Iterator itr = this.nodes.iterator();
        while (itr.hasNext()) {
            arrNodes.add((BayesNode)itr.next());
        }
        return arrNodes;
    }

    public ArrayList<BayesNode> getRegularNodes() {
        return this.getNodes(7777);
    }

    public ArrayList<BayesNode> getDecisionNodes() {
        return this.getNodes(7778);
    }

    protected ArrayList<BayesNode> getDecisionNodesOrdered() {
        ArrayList<BayesNode> orderedDecisionNodes = new ArrayList<BayesNode>();
        ArrayList<BayesNode> decisionNodes = this.getDecisionNodes();
        ArrayList<BayesNode> graphNodes = this.getAllNodes();
        ArrayList<BayesNode> usedNodes = new ArrayList<BayesNode>();
        while (!graphNodes.isEmpty()) {
            if (!this.isAtMostOneDecisionNodeWithNoIncomingArcs(decisionNodes, usedNodes)) {
                return null;
            }
            BayesNode curNode = this.getNextNoInArcsNode(graphNodes, usedNodes);
            if (curNode == null) {
                this.canvas.showMessage("Error", "Cycle in the graph.");
                return null;
            }
            if (curNode.getNodeType() == 7778) {
                orderedDecisionNodes.add(curNode);
            }
            usedNodes.add(curNode);
            graphNodes.remove(curNode);
        }
        return orderedDecisionNodes;
    }

    private boolean isAtMostOneDecisionNodeWithNoIncomingArcs(ArrayList<BayesNode> decisionNodes, ArrayList<BayesNode> usedNodes) {
        boolean isOneDecisionWithNoIncomingArcs = false;
        for (BayesNode node : decisionNodes) {
            if (usedNodes.contains(node) || !usedNodes.containsAll(node.getParents())) continue;
            if (isOneDecisionWithNoIncomingArcs) {
                return false;
            }
            isOneDecisionWithNoIncomingArcs = true;
        }
        return true;
    }

    private BayesNode getNextNoInArcsNode(ArrayList<BayesNode> graphNodes, ArrayList<BayesNode> usedNodes) {
        for (BayesNode node : graphNodes) {
            if (usedNodes.contains(node) || !usedNodes.containsAll(node.getParents())) continue;
            return node;
        }
        return null;
    }

    public ArrayList<BayesNode> getUtilityNodes() {
        return this.getNodes(7779);
    }

    public ArrayList<BayesNode> getEliminatedNodes() {
        ArrayList<BayesNode> eliminatedNodes = new ArrayList<BayesNode>(5);
        for (BayesNode curNode : this.nodes) {
            if (!curNode.isEliminated()) continue;
            eliminatedNodes.add(curNode);
        }
        return eliminatedNodes;
    }

    public ArrayList<BayesNode> getMonitoredNodes() {
        ArrayList<BayesNode> monitoredNodes = new ArrayList<BayesNode>(5);
        for (BayesNode node : this.nodes) {
            if (!node.isMonitored()) continue;
            monitoredNodes.add(node);
        }
        return monitoredNodes;
    }

    public ArrayList<BayesNode> getObservedNodes() {
        ArrayList<BayesNode> observedNodes = new ArrayList<BayesNode>(5);
        for (BayesNode node : this.nodes) {
            if (!node.isObserved()) continue;
            observedNodes.add(node);
        }
        return observedNodes;
    }

    protected void toggleMonitoring(BayesNode node) {
        if (node.isMonitored() && !node.isObserved()) {
            node.setIsMonitored(false);
            node.showHistogramView(false);
        } else if (!node.isObserved()) {
            Query.Result result = this.queryNodeResults(node, Inference.Heuristics.MIN_FILL);
            if (result == null) {
                return;
            }
            double[] results = new double[(int)result.getFactor().getSize()];
            FactorIterator itr = node.getNodeType() == 7779 ? result.getFactor().iterator() : result.getNormFactor().iterator();
            int i = 0;
            while (itr.hasNext()) {
                results[i++] = itr.next();
            }
            node.setIsMonitored(true);
            node.showHistogramView(true);
            node.setMonitoredProbs(results);
            node.setHistogramProbabilities(this.numDecimalsToMonitor);
            if (node.getNodeType() == 7778) {
                node.setHistogramNodeShape(1111);
            } else if (node.getNodeType() == 7777) {
                node.setHistogramNodeShape(1113);
            }
            this.updateNodeSize(node);
        }
    }

    public void updateMonitoredNodes() {
        this.buildDecisionNetwork();
        Iterator<BayesNode> itr = this.getMonitoredNodes().iterator();
        boolean isAllDecisionFunctionsDefined = ((BayesCanvas)this.canvas).isAllDecisionFunctionsDefined();
        while (itr.hasNext()) {
            BayesNode curNode = itr.next();
            this.toggleMonitoring(curNode);
            if (isAllDecisionFunctionsDefined) {
                this.toggleMonitoring(curNode);
            }
            if (isAllDecisionFunctionsDefined || itr.hasNext()) continue;
            this.canvas.showMessage("Notification", "All monitoring has been turned off as not all decision nodes have decision functions defined.");
        }
        this.canvas.repaint();
    }

    protected void queryNodeBrief(BayesNode node) {
        double[] results;
        if (node != null && node.isObserved()) {
            results = new double[node.getDomain().size()];
            Iterator<String> itr = node.getDomain().iterator();
            int i = 0;
            while (itr.hasNext()) {
                results[i++] = node.getObservation().equals(itr.next()) ? 1.0 : 0.0;
            }
        } else {
            Query.Result result = this.queryNodeResults(node, Inference.Heuristics.MIN_FILL);
            if (result == null) {
                return;
            }
            results = new double[(int)result.getFactor().getSize()];
            FactorIterator itr = node == null ? result.getFactor().iterator() : result.getNormFactor().iterator();
            int i = 0;
            while (itr.hasNext()) {
                results[i++] = itr.next();
            }
        }
        ((BayesCanvas)this.canvas).openAnswerDialog(node, results, this.getObservedNodes());
    }

    protected Query.Result queryNodeResults(BayesNode node, Inference.Heuristics heuristic) {
        Variable[] queryNode = null;
        queryNode = node != null ? new Variable[]{this.decisionNetwork.getVariable(node.getLabel())} : new Variable[]{};
        ArrayList<BayesNode> observedNodesList = this.getObservedNodes();
        Variable[] observedVariables = new Variable[observedNodesList.size()];
        int[] observedValues = new int[observedNodesList.size()];
        int i = 0;
        while (i < observedNodesList.size()) {
            BayesNode curNode = observedNodesList.get(i);
            observedVariables[i] = this.decisionNetwork.getVariable(curNode.getLabel());
            observedValues[i] = -1;
            int j = 0;
            while (j < observedVariables[i].getDomain().getSize()) {
                if (observedVariables[i].getDomain().getValue(j).equals(curNode.getObservation())) {
                    observedValues[i] = j;
                    break;
                }
                ++j;
            }
            if (observedValues[i] == -1) {
                this.showMessage("Error", "Observed value for node not found in variable for query, stopping query.");
                return null;
            }
            ++i;
        }
        this.config.setFactorSavingForTracing(false);
        this.config.setEliminationHeuristic(heuristic);
        if (node != null && node.getNodeType() == 7779) {
            try {
                return new QueryCompute(this.decisionNetwork, observedVariables, observedValues, this.config).getResult();
            }
            catch (ArithmeticException e) {
                this.showMessage("Error", "The conditional probability is undefined as the observations have zero probability.");
                return null;
            }
        }
        return new QueryCompute(queryNode, this.decisionNetwork, observedVariables, observedValues, this.config).getResult();
    }

    protected void clearDecisionFunctions() {
        Iterator<BayesNode> decItr = this.getDecisionNodes().iterator();
        while (decItr.hasNext()) {
            decItr.next().setDecisionFunction(null);
        }
        this.buildDecisionNetwork();
    }

    public boolean canOptimize() {
        ArrayList<BayesNode> observedNodesList = this.getObservedNodes();
        Variable[] observedVariables = new Variable[observedNodesList.size()];
        int[] observedValues = new int[observedNodesList.size()];
        int i = 0;
        while (i < observedNodesList.size()) {
            BayesNode curNode = observedNodesList.get(i);
            observedVariables[i] = this.decisionNetwork.getVariable(curNode.getLabel());
            observedValues[i] = -1;
            int j = 0;
            while (j < observedVariables[i].getDomain().getSize()) {
                if (observedVariables[i].getDomain().getValue(j).equals(curNode.getObservation())) {
                    observedValues[i] = j;
                    break;
                }
                ++j;
            }
            if (observedValues[i] == -1) {
                this.showMessage("Error", "Observed value for node not found in variable for query, stopping query.");
                return false;
            }
            ++i;
        }
        String message = Policy.checkInput(this.decisionNetwork, observedVariables, observedValues, this.config);
        if (message != null && message.startsWith("Observed variable can not depend on the decision variable without a decision function (")) {
            this.showMessage("Error", message);
            return false;
        }
        return true;
    }

    protected void optimizeGraphBrief(Inference.Heuristics heuristic, boolean showAnswer, boolean useExpandedDecisionFunction) {
        this.clearDecisionFunctions();
        ArrayList<BayesNode> observedNodesList = this.getObservedNodes();
        Variable[] observedVariables = new Variable[observedNodesList.size()];
        int[] observedValues = new int[observedNodesList.size()];
        int i = 0;
        while (i < observedNodesList.size()) {
            BayesNode curNode = observedNodesList.get(i);
            observedVariables[i] = this.decisionNetwork.getVariable(curNode.getLabel());
            observedValues[i] = -1;
            int j = 0;
            while (j < observedVariables[i].getDomain().getSize()) {
                if (observedVariables[i].getDomain().getValue(j).equals(curNode.getObservation())) {
                    observedValues[i] = j;
                    break;
                }
                ++j;
            }
            if (observedValues[i] == -1) {
                this.showMessage("Error", "Observed value for node not found in variable for query, stopping query.");
                return;
            }
            ++i;
        }
        this.config.setFactorSavingForTracing(false);
        this.config.setEliminationHeuristic(heuristic);
        Policy.Result result = null;
        result = new PolicyCompute(this.decisionNetwork, observedVariables, observedValues, this.config).getResult();
        this.config.setFactorSavingForTracing(true);
        for (BayesNode curNode : this.getDecisionNodes()) {
            curNode.setDecisionFunctionCreatedBy(7784);
            curNode.setDecisionFunction(result.getDecisionFunction((VariableDecision)this.decisionNetwork.getVariable(curNode.getLabel()), useExpandedDecisionFunction));
        }
        if (showAnswer) {
            double[] results = new double[]{result.getNormFactor().iterator().next()};
            ((BayesCanvas)this.canvas).openAnswerDialog(this.getUtilityNodes().get(0), results, this.getObservedNodes());
        }
        this.buildDecisionNetwork();
    }

    protected void parseBIF(BufferedReader in) throws Exception {
        this.config.setFactorSavingForTracing(true);
        this.decisionNetwork = new DecisionNetworkFromBIFv0_10(in, this.config);
        this.parse(this.decisionNetwork);
    }

    protected void parseXMLBIF(BufferedReader in) throws Exception {
        this.config.setFactorSavingForTracing(true);
        Pair<List<DecisionNetwork>, List<String>> networks = DecisionNetworkFromXMLBIFv0_3.create(in, this.config);
        if (networks.getFirstElement().size() == 0) {
            throw new Exception("No decision network defined.");
        }
        this.decisionNetwork = networks.getFirstElement().get(0);
        if (networks.getSecondElement().size() != 0 || networks.getFirstElement().size() > 1) {
            String warnings = "";
            if (networks.getFirstElement().size() > 1) {
                warnings = "Multiple decision networks defined in a single file. Only the first one will be used.\n\n";
            }
            for (String warning : networks.getSecondElement()) {
                warnings = warnings.concat(warning);
                warnings = warnings.concat("\n\n");
            }
            this.showMessage("Warning", warnings);
        }
        this.parse(this.decisionNetwork);
    }

    private void parse(DecisionNetwork network) throws Exception {
        FactorIterator itr;
        ArrayList<Double> probVec;
        BayesNode parentNode;
        BayesNode element;
        int n;
        BayesNode[] bayesNodeArray;
        BayesNode curNode;
        Variable curVar;
        this.nodes = new ArrayList();
        this.edges = new ArrayList();
        this.setScale(1.0f);
        FactorUtility utilFactor = null;
        BayesNode[] allNodes = null;
        Iterator<Variable> varItr = network.getVariables();
        this.name = network.getName(false);
        this.graphProperties.clear();
        Iterator<Property> graphPropertiesIterator = network.properties().get();
        this.setShortDesc("");
        this.setDetailedDesc("");
        while (graphPropertiesIterator.hasNext()) {
            Property prop = graphPropertiesIterator.next();
            this.graphProperties.add(prop);
            if (!(prop instanceof PropertyGeneric)) continue;
            PropertyGeneric gen = (PropertyGeneric)prop;
            if (gen.getName().equals("short")) {
                this.setShortDesc(gen.getValue());
            }
            if (!gen.getName().equals("detailed")) continue;
            this.setDetailedDesc(gen.getValue());
        }
        while (varItr.hasNext()) {
            curVar = varItr.next();
            allNodes = this.getAllNodes().toArray(new BayesNode[0]);
            curNode = new BayesNode(this);
            curNode.setLabel(curVar.getName(false));
            bayesNodeArray = allNodes;
            n = allNodes.length;
            int gen = 0;
            while (gen < n) {
                element = bayesNodeArray[gen];
                if (element.getLabel().equals(curNode.getLabel())) {
                    throw new Exception("Variable name \"" + curNode.getLabel() + "\" has already been used.");
                }
                ++gen;
            }
            PropertyPosition curVarPosition = curNode.setVariableProperties(network.variableProperties(curVar).getVariableProperties().get(), true);
            if (curVarPosition == null) {
                curVarPosition = new PropertyPosition(0.0, 0.0);
            }
            curNode.setDefinitionProperties(network.variableProperties(curVar).getDefinitionProperties().get(), false);
            curNode.setPosition(new Point(new Float(curVarPosition.getPosX()).floatValue(), new Float(curVarPosition.getPosY()).floatValue()));
            Iterator<?> domainIterator = curVar.getDomain().iterator();
            curNode.clearDomain();
            while (domainIterator.hasNext()) {
                curNode.addDomainElement((String)domainIterator.next());
            }
            if (curVar instanceof VariableDecision) {
                curNode.setNodeType(7778);
                curNode.setNodeAppearance(7778);
            } else {
                curNode.setNodeType(7777);
                curNode.setNodeAppearance(7777);
            }
            this.addNode(curNode);
        }
        if (this.isDecisionNetwork(false)) {
            utilFactor = network.getUtility();
            allNodes = this.getAllNodes().toArray(new BayesNode[0]);
            curNode = new BayesNode(this);
            curNode.setLabel(utilFactor.getUtilityName());
            bayesNodeArray = allNodes;
            n = allNodes.length;
            int gen = 0;
            while (gen < n) {
                element = bayesNodeArray[gen];
                if (element.getLabel().equals(curNode.getLabel())) {
                    throw new Exception("Variable name \"" + curNode.getLabel() + "\" has already been used.");
                }
                ++gen;
            }
            PropertyPosition utilFactorPosition = curNode.setDefinitionProperties(network.utilityProperties().get(), true);
            if (utilFactorPosition == null) {
                utilFactorPosition = new PropertyPosition(0.0, 0.0);
            }
            curNode.setPosition(new Point(new Float(utilFactorPosition.getPosX()).floatValue(), new Float(utilFactorPosition.getPosY()).floatValue()));
            curNode.setNodeType(7779);
            curNode.setNodeAppearance(7779);
            this.addNode(curNode);
            int j = 0;
            while (j < utilFactor.getVariablesNum()) {
                parentNode = this.getNode(utilFactor.getVariable(j).getName(false));
                curNode.addParent(parentNode);
                parentNode.addChild(curNode);
                this.addEdge(new BayesEdge(this, parentNode, curNode, false));
                ++j;
            }
        }
        varItr = network.getVariables();
        while (varItr.hasNext()) {
            curVar = varItr.next();
            Iterator<Variable> parentsItr = network.getParents(curVar);
            curNode = this.getNode(curVar.getName(false));
            while (parentsItr.hasNext()) {
                parentNode = this.getNode(parentsItr.next().getName(false));
                curNode.addParent(parentNode);
                parentNode.addChild(curNode);
                this.addEdge(new BayesEdge(this, parentNode, curNode, false));
            }
        }
        Iterator<Factor> itrSafe = network.getFactors(false);
        while (itrSafe.hasNext()) {
            Factor curFactor = itrSafe.next();
            curNode = this.getNode(((FactorDirected)((Object)curFactor)).getChild().getName(false));
            if (curNode.getNodeType() == 7778) {
                curNode.setDecisionFunction((FactorDecision)curFactor);
                curNode.setDecisionFunctionCreatedBy(7788);
                continue;
            }
            probVec = new ArrayList(curNode.getNumProbabilities());
            if (((FactorDirected)((Object)curFactor)).getChildIndex() != curFactor.getVariablesNum() - 1) {
                Variable[] variables = new Variable[curFactor.getVariablesNum()];
                Iterator<Variable> variablesIterator = curFactor.getVariables();
                int index = ((FactorDirected)((Object)curFactor)).getChildIndex();
                int j = 0;
                while (j < index) {
                    variables[j++] = variablesIterator.next();
                }
                variables[variables.length - 1] = variablesIterator.next();
                while (variablesIterator.hasNext()) {
                    variables[j++] = variablesIterator.next();
                }
                curFactor = curFactor.reorder(variables, false, this.config.getFactorSavingForTracing());
            }
            itr = curFactor.iterator();
            while (itr.hasNext()) {
                probVec.add(new Double(itr.next()));
            }
            curNode.initProbs(probVec);
        }
        if (this.isDecisionNetwork(false)) {
            itr = utilFactor.iterator();
            probVec = new ArrayList<Double>();
            while (itr.hasNext()) {
                probVec.add(new Double(itr.next()));
            }
            this.getUtilityNodes().get(0).initProbs(probVec);
        }
    }

    protected String generateXMLBIFTextRep() {
        this.buildDecisionNetwork();
        if (this.decisionNetwork == null) {
            return "";
        }
        return DecisionNetworkFromXMLBIFv0_3.saveToString(this.decisionNetwork);
    }

    protected String generateBIFTextRep() {
        this.buildDecisionNetwork();
        if (this.decisionNetwork == null) {
            return "";
        }
        try {
            return DecisionNetworkFromBIFv0_10.saveToString(this.decisionNetwork);
        }
        catch (UnsupportedOperationException e) {
            this.canvas.showMessage("Error", e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateFromText(String allText, int fileFormat) {
        String oldGraph = this.generateXMLBIFTextRep();
        try {
            block2 : switch (fileFormat) {
                case 8901: {
                    this.decisionNetwork = new DecisionNetworkFromBIFv0_10(allText, this.config);
                    break;
                }
                case 8902: {
                    Pair<List<DecisionNetwork>, List<String>> networks = DecisionNetworkFromXMLBIFv0_3.create(allText, this.config);
                    if (networks.getFirstElement().size() == 0) {
                        throw new Exception("No decision network defined.");
                    }
                    this.decisionNetwork = networks.getFirstElement().get(0);
                    if (networks.getSecondElement().size() == 0 && networks.getFirstElement().size() <= 1) break;
                    String warnings = "";
                    if (networks.getFirstElement().size() > 1) {
                        warnings = "Multiple decision networks defined in a single file. Only the first one will be used.\n\n";
                    }
                    Iterator<String> iterator = networks.getSecondElement().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.showMessage("Warning", warnings);
                            break block2;
                        }
                        String warning = iterator.next();
                        warnings = warnings.concat(warning);
                        warnings = warnings.concat("\n\n");
                    }
                }
                default: {
                    this.showMessage("Error", "Invalid format: " + fileFormat);
                    return false;
                }
            }
            this.parse(this.decisionNetwork);
        }
        catch (Exception e) {
            this.showMessage("Error", e.getLocalizedMessage());
            try {
                this.decisionNetwork = DecisionNetworkFromXMLBIFv0_3.create(oldGraph, this.config).getFirstElement().get(0);
                this.parse(this.decisionNetwork);
                ((BayesWindow)this.canvas.parent).setQueryEvidenceButton();
                return false;
            }
            catch (Exception e1) {
                this.showMessage("Error", "Error reverting to old graph: " + e1.getMessage());
                this.decisionNetwork = null;
            }
            return false;
        }
        ((BayesWindow)this.canvas.parent).setDecisionNetworkMode(this.isDecisionNetwork(false));
        ((BayesWindow)this.canvas.parent).setQueryEvidenceButton();
        this.buildDecisionNetwork();
        return true;
    }
}

