/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes;

import AIspace.bayes.BayesGraph;
import AIspace.bayes.BayesWindow;
import AIspace.bayes.InlineBayesApplet;
import AIspace.bayes.dialogs.AnswerDialog;
import AIspace.bayes.dialogs.BayesTextFrame;
import AIspace.bayes.dialogs.MoreMsgDialog;
import AIspace.bayes.dialogs.NodeDialog;
import AIspace.bayes.dialogs.ObservationDialog;
import AIspace.bayes.dialogs.PolicyDialog;
import AIspace.bayes.dialogs.ProbabilityDialog;
import AIspace.bayes.dialogs.QueryTypeDialog;
import AIspace.bayes.dialogs.UtilityDialog;
import AIspace.bayes.elements.BayesEdge;
import AIspace.bayes.elements.BayesNode;
import AIspace.bayes.quiz.QuizWindow;
import AIspace.bayes.verboseQuery.QueryWindow;
import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.HistogramNode;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.AIspace.ve.Inference;

public class BayesCanvas
extends GraphCanvas {
    public static final int C_MOD_PROB_UTIL = 3336;
    public static final int C_MAKE_OBSERVATION = 3337;
    public static final int C_QUERY_NODE = 3338;
    public static final int C_TOGGLE_MONITOR = 3340;
    public static final int C_VIEW_POLICY = 3341;
    public static final int FORMAT_BIF = 8901;
    public static final int FORMAT_XMLBIF = 8902;
    private NodeDialog nodePropDialog;
    private QuizWindow quizWindow;
    private QueryWindow queryWindow;

    public BayesCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.setFont(parent.getFont());
        this.graph = new BayesGraph(this);
    }

    @Override
    protected void popupCanvas(int x, int y) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        JMenuItem mItem;
        this.pop.removeAll();
        if (this.mode == 2220) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
            mItem = new JMenuItem("Create Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        } else {
            this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
            if (((BayesGraph)this.graph).getDecisionNetwork() != null && ((BayesWindow)this.parent).isDecisionNetworkModeEnabled() && ((BayesGraph)this.graph).getUtilityNodes().size() == 1) {
                if (((BayesGraph)this.graph).getObservedNodes().size() > 0) {
                    mItem = new JMenuItem("P(e) Query");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                }
                mItem = new JMenuItem("Optimize Decisions");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
                mItem = new JMenuItem("Add No-forgetting Arcs");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            if (((BayesGraph)this.graph).getDecisionNetwork() != null) {
                mItem = new JMenuItem("Independence Quiz");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
        }
        this.pop.addSeparator();
        this.pop.add(new JLabel("View Options"));
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupEdge(int x, int y) {
        this.pop.removeAll();
        if (this.mode == 2220) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Arc Options"));
            JMenuItem mItem = new JMenuItem("Delete Arc");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        }
    }

    @Override
    protected void popupNode(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        if (this.mode == 2220) {
            JMenuItem mItem = new JMenuItem("Create Arc");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Delete Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Set Properties of Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            if (((BayesNode)this.entClicked).getNodeType() == 7777) {
                this.pop.addSeparator();
                mItem = new JMenuItem("Modify Probability Table of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            if (((BayesNode)this.entClicked).getNodeType() == 7779 && ((BayesWindow)this.parent).isDecisionNetworkModeEnabled()) {
                this.pop.addSeparator();
                mItem = new JMenuItem("Modify Utility Table of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            if (((BayesWindow)this.parent).isDecisionNetworkModeEnabled()) {
                this.pop.addSeparator();
                if (((BayesNode)this.entClicked).getNodeType() != 7777) {
                    mItem = new JMenuItem("Set as Regular Node");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                }
                if (((BayesNode)this.entClicked).getNodeType() != 7778) {
                    mItem = new JMenuItem("Set as Decision Node");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                }
                if (((BayesNode)this.entClicked).getNodeType() != 7779 && ((BayesGraph)this.graph).getUtilityNodes().size() == 0) {
                    mItem = new JMenuItem("Set as Utility Node");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                }
            }
        } else if (this.mode == 2221) {
            JMenuItem mItem;
            if (((BayesNode)this.entClicked).getNodeType() != 7779) {
                if (((BayesNode)this.entClicked).isObserved()) {
                    mItem = new JMenuItem("Change Observation for Node");
                    mItem.setActionCommand(mItem.getText());
                } else {
                    mItem = new JMenuItem("Make Observation for Node");
                    mItem.setActionCommand(mItem.getText());
                }
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            if (((BayesGraph)this.graph).getDecisionNetwork() != null) {
                mItem = new JMenuItem("Query Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
                mItem = new JMenuItem("Toggle Monitoring of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            }
            boolean decisionNetworkEnabled = this.parent instanceof BayesWindow ? ((BayesWindow)this.parent).isDecisionNetworkModeEnabled() : ((InlineBayesApplet)this.parent).isDecisionNetworkModeEnabled();
            if (((BayesNode)this.entClicked).getNodeType() == 7777) {
                this.pop.addSeparator();
                mItem = new JMenuItem("View Probability Table of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                this.pop.add(mItem);
            } else if (decisionNetworkEnabled) {
                if (((BayesNode)this.entClicked).getNodeType() == 7779) {
                    this.pop.addSeparator();
                    mItem = new JMenuItem("View Utility Table of Node");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                } else if (((BayesNode)this.entClicked).getNodeType() == 7778) {
                    this.pop.addSeparator();
                    mItem = new JMenuItem("View/Modify Decision of Node");
                    mItem.setActionCommand(mItem.getText());
                    mItem.addActionListener(this);
                    this.pop.add(mItem);
                }
            }
        }
        this.pop.show(this, x, y);
    }

    protected void buildDecisionNetwork() {
        ((BayesGraph)this.graph).buildDecisionNetwork();
    }

    protected void parseBIF(BufferedReader in) throws Exception {
        ((BayesGraph)this.graph).parseBIF(in);
        this.repaint();
        this.autoscale();
    }

    protected void parseXMLBIF(BufferedReader in) throws Exception {
        ((BayesGraph)this.graph).parseXMLBIF(in);
        this.repaint();
        this.autoscale();
    }

    public void querySetup(BayesNode node) {
        if (((BayesGraph)this.graph).isDecisionNetwork(true) && !this.isAllDecisionFunctionsDefined()) {
            this.showMessage("Error", "All Decision Nodes must have a policy defined.", "Either create the policies by hand, or optimize the graph.");
            return;
        }
        if (this.getQueryMode() == 8882) {
            new QueryTypeDialog(this.parent, this, node, false);
        } else {
            this.queryNode(node, this.getQueryMode(), false);
        }
    }

    protected void optimizeDecisions() {
        if (((BayesGraph)this.graph).canOptimize()) {
            if (this.getQueryMode() == 8882) {
                new QueryTypeDialog(this.parent, this, ((BayesGraph)this.graph).getUtilityNodes().get(0), true);
            } else {
                this.queryNode(((BayesGraph)this.graph).getUtilityNodes().get(0), this.getQueryMode(), true);
            }
        }
    }

    protected boolean isAllDecisionFunctionsDefined() {
        Iterator<BayesNode> itr = ((BayesGraph)this.graph).getDecisionNodes().iterator();
        while (itr.hasNext()) {
            if (itr.next().getDecisionFunction() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isOneDecisionFunctionDefined() {
        Iterator<BayesNode> itr = ((BayesGraph)this.graph).getDecisionNodes().iterator();
        while (itr.hasNext()) {
            if (itr.next().getDecisionFunction() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isOneDecisionObserved() {
        Iterator<BayesNode> itr = ((BayesGraph)this.graph).getDecisionNodes().iterator();
        while (itr.hasNext()) {
            if (!itr.next().isObserved()) continue;
            return true;
        }
        return false;
    }

    public void queryNode(BayesNode node, int queryType, boolean isOptimizing) {
        if (isOptimizing) {
            ArrayList<BayesNode> decNodes = ((BayesGraph)this.graph).getDecisionNodes();
            for (BayesNode decNode : decNodes) {
                if (!decNode.isObserved()) continue;
                decNode.setObservation("");
            }
        }
        ((BayesGraph)this.graph).buildDecisionNetwork();
        switch (queryType) {
            case 8880: {
                if (isOptimizing) {
                    ((BayesGraph)this.graph).optimizeGraphBrief(Inference.Heuristics.MIN_FILL, true, true);
                    break;
                }
                ((BayesGraph)this.graph).queryNodeBrief(node);
                break;
            }
            case 8881: {
                if (isOptimizing) {
                    ((BayesGraph)this.graph).clearDecisionFunctions();
                }
                if (this.inline) {
                    ((InlineBayesApplet)this.parent).convertToQuery(new QueryWindow(this.parent, ((BayesGraph)this.graph).getDecisionNetwork(), node, ((BayesGraph)this.graph).getObservedNodes(), isOptimizing));
                    break;
                }
                this.queryWindow = new QueryWindow(this.parent, ((BayesGraph)this.graph).getDecisionNetwork(), node, ((BayesGraph)this.graph).getObservedNodes(), isOptimizing);
                break;
            }
            default: {
                this.querySetup(node);
            }
        }
    }

    protected void openAnswerDialog(BayesNode node, double[] results, ArrayList<BayesNode> observedNodes) {
        new AnswerDialog(this.parent, node, results, observedNodes);
    }

    protected void startQuiz() {
        if (this.quizWindow != null) {
            this.quizWindow.dispose();
        }
        this.quizWindow = new QuizWindow(this.parent, ((BayesGraph)this.graph).getDecisionNetwork());
    }

    protected int getQueryMode() {
        return ((BayesWindow)this.parent).getQueryMode();
    }

    @Override
    public void disposeWindows() {
        super.disposeWindows();
        if (this.nodePropDialog != null) {
            this.nodePropDialog.dispose();
        }
        if (this.quizWindow != null) {
            this.quizWindow.dispose();
        }
        if (this.queryWindow != null) {
            this.queryWindow.dispose();
        }
    }

    public void showMessage(String title, String msg, String more) {
        new MoreMsgDialog((JFrame)this.parent, title, msg, more);
    }

    @Override
    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent.type != 7770) {
            BayesNode node = new BayesNode((BayesGraph)this.graph);
            node.setPosition(p);
            node.setNodeAppearance(7777);
            node.setLabel("Node " + this.graph.getNextIndex());
            java.awt.Point screenp = new java.awt.Point((int)p.x, (int)p.y);
            SwingUtilities.convertPointToScreen(screenp, this);
            if (this.nodePropDialog != null) {
                this.nodePropDialog.dispose();
            }
            this.nodePropDialog = new NodeDialog((JFrame)this.parent, (BayesGraph)this.graph, new Point(screenp.x, screenp.y));
            this.nodePropDialog.open(node);
            if (!this.nodePropDialog.isCancelled()) {
                node.initProbs();
                this.graph.addNode(node);
                this.updateGraph();
            }
        }
    }

    @Override
    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.to = (BayesNode)ent;
                if (this.to.getIndex() == this.from.getIndex() || ((BayesNode)this.from).getNodeType() == 7779 || BayesNode.isDescendentOf((BayesNode)this.from, (BayesNode)this.to) || BayesNode.isChildOf((BayesNode)this.from, (BayesNode)this.to)) {
                    this.makingEdge = 0;
                    return;
                }
                this.makingEdge = 2;
                BayesEdge edge = new BayesEdge((BayesGraph)this.graph, this.from, this.to, false);
                ((BayesNode)this.to).addParent((BayesNode)this.from);
                ((BayesNode)this.from).addChild((BayesNode)this.to);
                this.graph.addEdge(edge);
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (BayesNode)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    @Override
    protected void setEntProperties(Entity ent) {
        if (ent.type == 7770) {
            java.awt.Point screenp = new java.awt.Point((int)((BayesNode)ent).pos.x, (int)((BayesNode)ent).pos.y);
            SwingUtilities.convertPointToScreen(screenp, this);
            if (this.nodePropDialog != null) {
                this.nodePropDialog.dispose();
            }
            this.nodePropDialog = new NodeDialog((JFrame)this.parent, (BayesGraph)this.graph, new Point(screenp.x, screenp.y));
            this.nodePropDialog.open((BayesNode)ent);
            this.graph.updateNodeSize((Node)ent);
        }
    }

    protected void setNode(BayesNode node, int type) {
        if (type == 7779 && node.getChildren().size() != 0) {
            this.showMessage("Error", "Utility nodes cannot have outgoing edges.");
            return;
        }
        node.setNodeAppearance(type);
        node.setNodeType(type);
        this.graph.updateNodeSize(node);
    }

    protected void displayNodeLabels(boolean display) {
        Iterator<BayesNode> itr = ((BayesGraph)this.graph).getAllNodes().iterator();
        while (itr.hasNext()) {
            itr.next().setDrawingExtra(display);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.mPressedPos.move(p);
        this.mDraggedPos.move(p);
        this.mOriginalPos.move(p);
        Entity entClicked = this.graph.searchEntities(p);
        if (e.getModifiers() == 4) {
            return;
        }
        if (entClicked == null && !e.isControlDown() && !e.isShiftDown()) {
            this.graph.deselectAll();
            if (this.pop.isVisible()) {
                this.pop.setVisible(false);
                return;
            }
        }
        this.checkAndResetSubMode(entClicked);
        if (this.mode == 2220) {
            if (entClicked == null || entClicked instanceof Edge) {
                super.mousePressed(e);
            } else if (this.submode == 3336) {
                switch (((BayesNode)entClicked).getNodeType()) {
                    case 7778: {
                        this.showMessage("Error", "Decision nodes have neither probability nor utility tables.", "");
                        break;
                    }
                    case 7779: {
                        new UtilityDialog((JFrame)this.parent, (BayesNode)entClicked, this, true);
                        break;
                    }
                    case 7777: {
                        new ProbabilityDialog((JFrame)this.parent, (BayesNode)entClicked, this, true);
                    }
                }
            } else {
                super.mousePressed(e);
            }
        } else if (this.mode == 2221) {
            if (entClicked == null || entClicked instanceof Edge) {
                super.mousePressed(e);
                return;
            }
            this.isMoving = false;
            switch (this.submode) {
                case 3337: {
                    if (((BayesNode)entClicked).getNodeType() == 7779) {
                        this.showMessage("Error", "Observations can only be made for regular or decision nodes.", "Since value nodes have only one domain value, and are not probabilistic, they cannot be observed.");
                        break;
                    }
                    if (((BayesNode)entClicked).getNodeType() == 7778 && ((BayesNode)entClicked).getDecisionFunction() == null) {
                        this.showMessage("Error", "Decision function must be defined for the decision node before an observation can be made.");
                        new PolicyDialog((JFrame)this.parent, (BayesNode)entClicked, this);
                    }
                    if (((BayesNode)entClicked).getNodeType() == 7778 && ((BayesNode)entClicked).getDecisionFunction() == null) break;
                    new ObservationDialog(this.parent, (BayesNode)entClicked);
                    ((BayesNode)entClicked).updateSize();
                    ((BayesNode)entClicked).updatePosition();
                    break;
                }
                case 3341: {
                    if (((BayesNode)entClicked).getNodeType() == 7778) {
                        if (this.inline) {
                            new PolicyDialog(null, (BayesNode)entClicked, this);
                            break;
                        }
                        new PolicyDialog((JFrame)this.parent, (BayesNode)entClicked, this);
                        break;
                    }
                    this.showMessage("Error", "Only Decision Nodes have decision functions.", "A decision function is a function that outputs (deterministically) what the value of the node will be, given the values of its parents.");
                    break;
                }
                case 3338: {
                    this.querySetup((BayesNode)entClicked);
                    break;
                }
                case 3340: {
                    if (((BayesGraph)this.graph).isDecisionNetwork(true) && !this.isAllDecisionFunctionsDefined()) {
                        this.showMessage("Error", "All Decision Nodes must have a policy defined.", "Either create the policies by hand, or optimize the graph.");
                        return;
                    }
                    ((BayesGraph)this.graph).toggleMonitoring((BayesNode)entClicked);
                    this.graph.deselectAll();
                    this.mPressedSelect(entClicked, e.isControlDown());
                    break;
                }
                case 3336: {
                    if (((BayesNode)entClicked).getNodeType() == 7778) {
                        this.showMessage("Error", "Decision nodes have neither probability nor utility tables.", "Decision nodes have decision functions. Try viewing the decision of the node.");
                        break;
                    }
                    if (((BayesNode)entClicked).getNodeType() == 7779) {
                        if (this.inline) {
                            new UtilityDialog(null, (BayesNode)entClicked, this, false);
                            break;
                        }
                        new UtilityDialog((JFrame)this.parent, (BayesNode)entClicked, this, false);
                        break;
                    }
                    if (this.inline) {
                        new ProbabilityDialog(null, (BayesNode)entClicked, this, false);
                        break;
                    }
                    new ProbabilityDialog((JFrame)this.parent, (BayesNode)entClicked, this, false);
                    break;
                }
                case 3332: {
                    this.mPressedSelect(entClicked, false);
                    this.graph.deselectAll();
                    break;
                }
                default: {
                    super.mousePressed(e);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Entity ent = this.graph.searchEntities(new Point(e.getX(), e.getY()));
        if (this.submode == 3340) {
            this.mReleasedSelect(ent, e.isControlDown());
        }
        super.mouseReleased(e);
        Iterator<Node> nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            HistogramNode n = (HistogramNode)nodeItr.next();
            n.updatePosition();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        Entity entClicked = this.graph.searchEntities(p);
        if (this.mode == 2220) {
            super.mouseDragged(e);
        } else if (this.mode == 2221) {
            if (e.getModifiers() == 4) {
                super.mouseDragged(e);
            } else if (this.submode == 3332 || this.submode == 3340) {
                this.mDraggedSelect();
            }
        }
    }

    public void displayTextRep(int fileFormat, boolean modify) {
        String textRep = "";
        String title = "BIF Representation of the Graph";
        if (fileFormat == 8901) {
            textRep = ((BayesGraph)this.graph).generateBIFTextRep();
        } else if (fileFormat == 8902) {
            textRep = ((BayesGraph)this.graph).generateXMLBIFTextRep();
            title = "XML" + title;
        }
        if (textRep != null) {
            new BayesTextFrame(this, textRep, title, fileFormat, modify);
        }
    }

    public boolean updateGraphFromText(String allText, int fileFormat) {
        boolean isSuccessful = ((BayesGraph)this.graph).updateFromText(allText, fileFormat);
        this.autoscale();
        return isSuccessful;
    }

    @Override
    public void reset() {
        super.reset();
        this.graph = new BayesGraph(this);
    }

    protected void setDecisionNetworkMode(boolean isEnabled) {
        ((BayesWindow)this.parent).setDecisionNetworkMode(isEnabled);
    }

    @Override
    public void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        super.aPerformed(e);
        if (arg.equals("Autoscale")) {
            Iterator<Node> nodeItr = this.graph.getNodes();
            while (nodeItr.hasNext()) {
                HistogramNode n = (HistogramNode)nodeItr.next();
                n.updatePosition();
            }
            return;
        }
        if (this.getMode() == 2220) {
            if (arg.equals("Set as Utility Node")) {
                this.setNode((BayesNode)this.entClicked, 7779);
            } else if (arg.equals("Set as Decision Node")) {
                this.setNode((BayesNode)this.entClicked, 7778);
            } else if (arg.equals("Set as Regular Node")) {
                this.setNode((BayesNode)this.entClicked, 7777);
            } else if (arg.equals("Create Arc")) {
                this.createEdge(this.entClicked, this.mClickedPos);
                this.tmpMode = this.submode;
                this.submode = 3331;
            } else if (arg.equals("Modify Probability Table of Node")) {
                new ProbabilityDialog((JFrame)this.parent, (BayesNode)this.entClicked, this, true);
            } else if (arg.equals("Modify Utility Table of Node")) {
                new UtilityDialog((JFrame)this.parent, (BayesNode)this.entClicked, this, true);
            }
        } else if (this.getMode() == 2221) {
            if (arg.equals("Make Observation for Node") || arg.equals("Change Observation for Node")) {
                new ObservationDialog(this.parent, (BayesNode)this.entClicked);
            } else if (arg.equals("View Probability Table of Node")) {
                new ProbabilityDialog((JFrame)this.parent, (BayesNode)this.entClicked, this, false);
            } else if (arg.equals("View Utility Table of Node")) {
                new UtilityDialog((JFrame)this.parent, (BayesNode)this.entClicked, this, false);
            } else if (arg.equals("Toggle Monitoring of Node")) {
                ((BayesGraph)this.graph).toggleMonitoring((BayesNode)this.entClicked);
            } else if (arg.equals("Query Node")) {
                this.querySetup((BayesNode)this.entClicked);
            } else if (arg.equals("View/Modify Decision of Node")) {
                if (((BayesNode)this.entClicked).getNodeType() == 7778) {
                    new PolicyDialog((JFrame)this.parent, (BayesNode)this.entClicked, this);
                } else {
                    this.showMessage("Error", "Only Decision Nodes have decision functions.", "A decision function is a function that outputs (deterministically) what the value of the node will be, given the values of its parents.");
                }
            } else if (arg.equals("Add No-forgetting Arcs")) {
                ((BayesWindow)this.parent).addNoForgettingArcs();
            } else if (arg.equals("Optimize Decisions")) {
                ((BayesWindow)this.parent).optimizeDecisions();
            } else if (arg.equals("Independence Quiz")) {
                this.startQuiz();
            } else if (arg.equals("P(e) Query")) {
                this.querySetup(null);
            }
        }
        this.repaint();
    }

    @Override
    public void changeFont(int size) {
        this.setFont(new Font(this.getFont().getFontName(), this.getFont().getStyle(), size));
        this.parent.setFont(new Font(this.getFont().getFontName(), this.getFont().getStyle(), size));
        super.changeFont(size);
    }
}

