/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve.examples;

import org.AIspace.ve.Configuration;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorCPT;
import org.AIspace.ve.Query;
import org.AIspace.ve.QueryCompute;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableNature;
import org.AIspace.ve.domains.predefined.DomainBoolean;
import org.AIspace.ve.parsers.factors.DecisionNetworkFromFactors;

public class FireFactors {
    public static void main(String[] args) {
        DecisionNetworkFromFactors beliefNetwork;
        Configuration configuration = new Configuration();
        System.out.println("\n* Configuration:");
        System.out.println(configuration.toString(false));
        VariableNature tampering = new VariableNature("tampering", DomainBoolean.instanceReversed);
        VariableNature fire = new VariableNature("fire", DomainBoolean.instanceReversed);
        VariableNature alarm = new VariableNature("alarm", DomainBoolean.instanceReversed);
        VariableNature smoke = new VariableNature("smoke", DomainBoolean.instanceReversed);
        VariableNature leaving = new VariableNature("leaving", DomainBoolean.instanceReversed);
        VariableNature report = new VariableNature("report", DomainBoolean.instanceReversed);
        Factor[] factors = new Factor[]{new FactorCPT(new Variable[]{tampering}, false, 0, new double[]{0.02, 0.98}, false, 0.0), new FactorCPT(new Variable[]{fire}, false, 0, new double[]{0.01, 0.99}, false, 0.0), new FactorCPT(new Variable[]{tampering, fire, alarm}, false, 2, new double[]{0.5, 0.5, 0.85, 0.15, 0.99, 0.01, 1.0E-4, 0.9999}, false, 0.0), new FactorCPT(new Variable[]{fire, smoke}, false, 1, new double[]{0.9, 0.1, 0.01, 0.99}, false, 0.0), new FactorCPT(new Variable[]{alarm, leaving}, false, 1, new double[]{0.88, 0.12, 0.001, 0.999}, false, 0.0), new FactorCPT(new Variable[]{leaving, report}, false, 1, new double[]{0.75, 0.25, 0.01, 0.99}, false, 0.0)};
        try {
            beliefNetwork = new DecisionNetworkFromFactors("Fire Alarm Belief Network", new Variable[]{tampering, fire, alarm, smoke, leaving, report}, factors, null, null, configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("* '" + beliefNetwork.getName(false) + "' network created.");
        System.out.println();
        System.out.println(beliefNetwork.toString(false, false));
        System.out.println("\n*** Querying 'report':");
        QueryCompute query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[0], new int[0], configuration);
        Query.Result result = query.getResult();
        System.out.println("* Result:");
        System.out.println(result.toString(false));
        System.out.println("\n*** Querying 'report' given observation 'smoke' = 'T':");
        query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration);
        System.out.println("* Result:");
        System.out.println(query.getResult().toString(false));
        System.out.println("\n*** Computing probability of evidence 'smoke' = 'T':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(new Variable[0], beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration).getResult().toString(false));
    }
}

