/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.Inference;
import org.AIspace.ve.MoralGraph;
import org.AIspace.ve.Query;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.tools.ItrIterator;

public abstract class Policy
extends Inference {
    final Result result;

    @Override
    public Result getResult() {
        return this.result.clone();
    }

    Policy(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(configuration);
        String error = Policy.checkInput(decisionNetwork, observedVars, observedVals, configuration);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.result = new Result(decisionNetwork, configuration);
    }

    Policy(Policy policy) {
        super(policy);
        this.result = policy.result.clone();
    }

    static final Variable[] determineToEliminate(Iterator<Variable> allVarsIterator, int nrAllVars, Variable[] observedVars) {
        Variable[] res = new Variable[nrAllVars - observedVars.length];
        int opos = 0;
        int respos = 0;
        while (allVarsIterator.hasNext()) {
            Variable variable = allVarsIterator.next();
            if (opos < observedVars.length && observedVars[opos].equals(variable)) {
                ++opos;
                continue;
            }
            res[respos++] = variable;
        }
        return res;
    }

    public static final String checkInput(DecisionNetwork dnet, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        if (dnet == null) {
            return "Decision Network is 'null'.";
        }
        if (!dnet.isConstructionFinished()) {
            return "Decision Network is not fully constructed.";
        }
        if (!dnet.isDecisionNetwork()) {
            return "It is not a decision network.";
        }
        if (dnet.isPolicyDefined()) {
            return "Policy function is already defined for the decision network.";
        }
        if (!dnet.isNoForgetting()) {
            return "Network wasn't verified as no-forgetting, inference can't be performed.";
        }
        if (observedVars.length != observedVals.length) {
            return "The number of the observed Variables is different from the number of values provided.";
        }
        HashMap<Variable, VariableDecision> dependencyMap = new HashMap<Variable, VariableDecision>();
        int i = 0;
        while (i < observedVars.length) {
            if (observedVars[i] == null) {
                return "Observed Variable number " + i + " is 'null'.";
            }
            if (!dnet.containsVariable(observedVars[i])) {
                return "Observed Variable (" + observedVars[i].getName(true) + ") is not in the Network.";
            }
            if (observedVars[i] instanceof VariableDecision && dnet.variableProperties(observedVars[i]).getFactorsNum() == 0) {
                return "Observation for Variable (" + observedVars[i].getName(true) + ") can not be projected, decision function for this Variable is undefined.";
            }
            if (observedVals[i] < 0 || observedVals[i] >= observedVars[i].getDomain().getSize()) {
                return "Invalid observation for Variable " + observedVars[i].getName(true) + ".";
            }
            if (i < observedVars.length - 1 && observedVars[i].compareTo(observedVars[i + 1]) >= 0) {
                return "Observed Variables are not in order.";
            }
            VariableDecision dependency = Policy.checkDependency(observedVars[i], dnet, observedVars, dependencyMap);
            if (dependency != null) {
                return "Observed variable can not depend on the decision variable without a decision function (" + observedVars[i].getName(false) + " depends on " + dependency.getName(false) + ").";
            }
            ++i;
        }
        if (configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.GIVEN)) {
            Variable[] toSumOut = Query.determineToSumOut(dnet.getVariables(), dnet.getNumVariables(), observedVars);
            Object[] givenOrdering = new Variable[configuration.eliminationOrdering().length];
            if (givenOrdering.length != toSumOut.length) {
                return "Given elimination ordering is incorrect.";
            }
            System.arraycopy(configuration.eliminationOrdering(), 0, givenOrdering, 0, givenOrdering.length);
            int i2 = 0;
            while (i2 < givenOrdering.length - 1) {
                if (dnet.variableProperties((Variable)givenOrdering[i2]).getDecisionHierarchyScore() > dnet.variableProperties((Variable)givenOrdering[i2 + 1]).getDecisionHierarchyScore()) {
                    return "Given elimination ordering is incorrect.";
                }
                ++i2;
            }
            Arrays.sort(givenOrdering);
            i2 = 0;
            while (i2 < toSumOut.length) {
                if (!toSumOut[i2].equals(givenOrdering[i2])) {
                    return "Given elimination ordering is incorrect.";
                }
                ++i2;
            }
        }
        return null;
    }

    private static final VariableDecision checkDependency(Variable variable, DecisionNetwork dnet, Variable[] observedVars, HashMap<Variable, VariableDecision> dependencyMap) {
        if (dependencyMap.containsKey(variable)) {
            return dependencyMap.get(variable);
        }
        Iterator<Variable> parentsIterator = dnet.getParents(variable);
        while (parentsIterator.hasNext()) {
            Variable parent = parentsIterator.next();
            if (Arrays.binarySearch(observedVars, parent) >= 0) continue;
            if (parent instanceof VariableDecision && dnet.variableProperties(parent).getFactorsNum() == 0) {
                dependencyMap.put(variable, (VariableDecision)parent);
                return (VariableDecision)parent;
            }
            VariableDecision parentDependency = dependencyMap.containsKey(parent) ? dependencyMap.get(parent) : Policy.checkDependency(parent, dnet, observedVars, dependencyMap);
            if (parentDependency == null) continue;
            dependencyMap.put(variable, parentDependency);
            return parentDependency;
        }
        dependencyMap.put(variable, null);
        return null;
    }

    static final void markRelevantNodes(DecisionNetwork decisionNetwork, Iterator<Variable> observedVariablesIterator, Set<Variable> relevantVariables, Set<Variable> observedVariables) {
        DecisionNetwork.DNGraph graph = decisionNetwork.getGraph();
        Iterator<Variable> utilityVariablesIterator = decisionNetwork.getUtility().getVariables();
        while (utilityVariablesIterator.hasNext()) {
            graph.markRelevant(relevantVariables, utilityVariablesIterator.next());
        }
        while (observedVariablesIterator.hasNext()) {
            Variable observedVariable = observedVariablesIterator.next();
            observedVariables.add(observedVariable);
            graph.markRelevant(relevantVariables, observedVariable);
        }
        Iterator<Variable> variablesIterator = decisionNetwork.getVariables();
        while (variablesIterator.hasNext()) {
            Variable variable = variablesIterator.next();
            if (relevantVariables.contains(variable)) continue;
            graph.removeNode(variable);
        }
        MoralGraph moralGraph = new MoralGraph(graph);
        relevantVariables.clear();
        utilityVariablesIterator = decisionNetwork.getUtility().getVariables();
        while (utilityVariablesIterator.hasNext()) {
            moralGraph.markRelevant(relevantVariables, utilityVariablesIterator.next(), observedVariables, decisionNetwork);
        }
    }

    public static final class Result
    extends Inference.Result {
        private final DecisionNetwork decisionNetwork;
        final HashMap<VariableDecision, FactorDecision> decisionToDecisionFunction = new HashMap();

        public FactorDecision getDecisionFunction(VariableDecision decisionVariable, boolean allParents) {
            FactorDecision function = this.decisionToDecisionFunction.get(decisionVariable);
            if (function == null) {
                throw new IllegalArgumentException("Decision function for " + decisionVariable + " is undefined.");
            }
            if (allParents) {
                return FactorDecision.expandFactor(function, this.decisionNetwork);
            }
            return function;
        }

        public Iterator<FactorDecision> getPolicy(boolean allParents) {
            if (allParents) {
                return new ItrIterator<FactorDecision>(this.decisionToDecisionFunction.values().iterator()){

                    @Override
                    public FactorDecision next() {
                        return FactorDecision.expandFactor((FactorDecision)this.iterator.next(), Result.this.decisionNetwork);
                    }
                };
            }
            return new ItrIterator<FactorDecision>(this.decisionToDecisionFunction.values().iterator());
        }

        Result(DecisionNetwork decisionNetwork, Configuration configuration) {
            super(configuration);
            this.decisionNetwork = decisionNetwork;
        }

        public Result(String fileName, Configuration configuration) {
            super(configuration);
            this.decisionNetwork = null;
        }

        private Result(Result result) {
            super(result);
            this.decisionNetwork = result.decisionNetwork;
            this.decisionToDecisionFunction.putAll(result.decisionToDecisionFunction);
        }

        @Override
        public void save() {
        }

        public String toString(boolean allParents, boolean asActions, boolean withId) {
            StringBuilder output = new StringBuilder();
            output.append("Result.policy:");
            Iterator<FactorDecision> decisionsFunctionIterator = this.getPolicy(allParents);
            while (decisionsFunctionIterator.hasNext()) {
                FactorDecision decisionFunction = decisionsFunctionIterator.next();
                output.append("\nDecision function ").append(decisionFunction.getInterpretation(withId)).append(":");
                output.append("\n").append(decisionFunction.toStringActions("   ", withId)).append("\n");
            }
            output.append(super.toString(withId));
            return output.toString();
        }

        @Override
        public String toString() {
            return this.toString(false, true, true);
        }

        @Override
        public Result clone() {
            return new Result(this);
        }
    }
}

