/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorObserved;
import org.AIspace.ve.Variable;

@NotThreadSafe
final class ObservedFactorsIterator
implements Iterator<Factor> {
    private final Iterator<Factor> factorsIterator;
    private final Variable[] observedVars;
    private final int[] observedVals;
    private final boolean countRelevantObservations;
    private int relevantObsNum;
    private final boolean saveForTracing;

    int getRelevantObsNum() {
        if (!this.countRelevantObservations) {
            throw new UnsupportedOperationException("Iterator wasn't counting relevantObservations.");
        }
        return this.relevantObsNum;
    }

    ObservedFactorsIterator(Iterator<Factor> factorsIterator, Variable[] observedVars, int[] observedVals, boolean countRelevantObservations, boolean saveForTracing) {
        this.factorsIterator = factorsIterator;
        this.observedVars = observedVars;
        this.observedVals = observedVals;
        this.countRelevantObservations = countRelevantObservations;
        this.saveForTracing = saveForTracing;
    }

    @Override
    public boolean hasNext() {
        return this.factorsIterator.hasNext();
    }

    @Override
    public Factor next() {
        if (this.factorsIterator.hasNext()) {
            Factor originalFactor = this.factorsIterator.next();
            if (this.countRelevantObservations && originalFactor instanceof FactorDirected && Arrays.binarySearch(this.observedVars, ((FactorDirected)((Object)originalFactor)).getChild()) >= 0) {
                ++this.relevantObsNum;
            }
            try {
                return FactorObserved.projectObservation(originalFactor, this.observedVars, this.observedVals, this.saveForTracing);
            }
            catch (IllegalArgumentException e) {
                return originalFactor;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

