/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.HashSet;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStoreIndexed;
import org.AIspace.ve.Inference;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;
import org.AIspace.ve.tools.PairComparable;

@NotThreadSafe
final class FactorStoreIndexedDN
extends FactorStoreIndexed<PairComparable<Integer, Long>> {
    FactorStoreIndexedDN(DecisionNetwork decisionNetwork, Variable[] toEliminate, Iterator<Factor> initFactorsIterator, int nrInitFactors, Iterator<Variable> variablesIterator, int numVariables, Inference.Heuristics how) {
        super(decisionNetwork, toEliminate, initFactorsIterator, nrInitFactors, variablesIterator, numVariables, how);
    }

    private FactorStoreIndexedDN(FactorStoreIndexedDN factorStore) {
        super(factorStore);
        this.varsPQ = new VariableToEliminate[factorStore.varsPQ.length];
        int i = 0;
        while (i < this.numVariablesToEliminate) {
            this.varsPQ[i] = new VariableToEliminate(factorStore.varsPQ[i]);
            if (factorStore.varsPQ[i].factors != null) {
                this.varsPQ[i].factors = (HashSet)this.factorIndex.get(this.varsPQ[i].var);
            }
            this.varToVarInQuery.put(this.varsPQ[i].var, this.varsPQ[i]);
            ++i;
        }
    }

    @Override
    void createHeapSpace(Variable[] toSumOut, int numVariables) {
        this.varsPQ = new VariableToEliminate[this.numVariablesToEliminate];
        int i = 0;
        while (i < this.numVariablesToEliminate) {
            this.varsPQ[i] = new VariableToEliminate(toSumOut[i], numVariables - 1);
            this.varToVarInQuery.put(toSumOut[i], this.varsPQ[i]);
            ++i;
        }
    }

    boolean canBeEliminated(Variable variable) {
        FactorStoreIndexed.VariableToEliminate varToE = (FactorStoreIndexed.VariableToEliminate)this.varToVarInQuery.get(variable);
        if (varToE == null) {
            throw new IllegalArgumentException("Variable " + variable + " can not be checked, it is not in the network now.");
        }
        return ((Integer)((PairComparable)varToE.heuristicValue).getFirstElement()).equals(((PairComparable)this.varsPQ[0].heuristicValue).getFirstElement()) && (!(variable instanceof VariableDecision) || this.varsPQ[0].var.equals(variable));
    }

    @Override
    public FactorStoreIndexedDN clone() {
        return new FactorStoreIndexedDN(this);
    }

    final class VariableToEliminate
    extends FactorStoreIndexed.VariableToEliminate {
        VariableToEliminate(Variable variable, int maxNumNeighs) {
            super(FactorStoreIndexedDN.this, variable, maxNumNeighs);
            this.heuristicValue = new PairComparable<Integer, Long>(FactorStoreIndexedDN.this.dnet.variableProperties(variable).getDecisionHierarchyScore(), 0L);
        }

        private VariableToEliminate(FactorStoreIndexed.VariableToEliminate variable) {
            super(FactorStoreIndexedDN.this, variable);
        }

        @Override
        void setMinDegree() {
            if (this.var instanceof VariableDecision) {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.MAX_VALUE);
            } else {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.valueOf(this.numNeighbors));
            }
        }

        @Override
        void setMinFill() {
            if (this.var instanceof VariableDecision) {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.MAX_VALUE);
            } else {
                ((PairComparable)this.heuristicValue).setSecondElement(this.recomputeMinFill());
            }
        }

        @Override
        void setMinFactor() {
            if (this.var instanceof VariableDecision) {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.MAX_VALUE);
            } else {
                ((PairComparable)this.heuristicValue).setSecondElement(this.recomputeMinFactor());
            }
        }

        @Override
        void setMaxCardinality() {
            if (this.var instanceof VariableDecision) {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.MAX_VALUE);
            } else {
                ((PairComparable)this.heuristicValue).setSecondElement(this.recomputeMaxCardinality());
            }
        }

        @Override
        void setGiven(int index) {
            if (this.var instanceof VariableDecision) {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.MAX_VALUE);
            } else {
                ((PairComparable)this.heuristicValue).setSecondElement(Long.valueOf(index));
            }
        }

        PairComparable<Integer, Long> cloneHeuristicValue() {
            return new PairComparable<Integer, Long>((Integer)((PairComparable)this.heuristicValue).getFirstElement(), (Long)((PairComparable)this.heuristicValue).getSecondElement());
        }
    }
}

