/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.BayesCanvas;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class UtilityDialog
extends BasicDialog {
    private ArrayList<Component> field_list;
    private BayesNode node;
    private BayesCanvas canvas;
    private boolean isEditable;

    public UtilityDialog(JFrame parent, BayesNode bNode, BayesCanvas canvas, boolean isEditable) {
        super(parent, "Utility Table for " + bNode.getLabel(), true, 2);
        GridBagConstraints con;
        JLabel label;
        this.setFont(canvas.getFont());
        this.canvas = canvas;
        this.node = bNode;
        this.isEditable = isEditable;
        ArrayList<BayesNode> nodeParents = this.node.getParents();
        this.getContentPane().setLayout(new BorderLayout());
        this.field_list = new ArrayList(this.node.getNumProbabilities());
        int contextSize = this.node.getContext().size();
        GridBagLayout gl = new GridBagLayout();
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(gl);
        Font bold = new Font(this.getFont().getFontName(), 1, this.getFont().getSize());
        int j = 0;
        while (j < nodeParents.size()) {
            label = new JLabel("   " + nodeParents.get(j).getLabel() + "   ");
            label.setFont(bold);
            label.setForeground(Color.blue);
            con = new GridBagConstraints();
            con.gridy = 0;
            con.gridx = j++;
            con.gridwidth = 1;
            con.gridheight = 1;
            gl.setConstraints(label, con);
            gridPanel.add(label);
        }
        label = new JLabel("Utility");
        label.setFont(bold);
        label.setForeground(Color.red);
        con = new GridBagConstraints();
        con.gridx = nodeParents.size();
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        if (nodeParents.size() == 0) {
            con.gridx = 1;
        }
        gl.setConstraints(label, con);
        gridPanel.add(label);
        int i = 0;
        while (i < contextSize) {
            ArrayList<String> curContext = this.node.getContext().get(i);
            int j2 = 0;
            while (j2 < curContext.size()) {
                label = new JLabel(curContext.get(j2));
                label.setFont(this.getFont());
                con = new GridBagConstraints();
                con.gridwidth = 1;
                con.gridheight = 1;
                con.gridx = j2++;
                con.gridy = i + 1;
                gl.setConstraints(label, con);
                gridPanel.add(label);
            }
            Double prob = this.node.getProbabilities().get(i).get(0);
            con = new GridBagConstraints();
            con.gridwidth = 1;
            con.gridheight = 1;
            con.gridx = this.node.getParents().size();
            if (this.node.getParents().size() == 0) {
                con.gridx = 1;
            }
            con.gridy = i + 1;
            if (isEditable) {
                JTextField tf = new JTextField(5);
                tf.setText(prob.toString());
                tf.setCaretPosition(0);
                tf.setFont(this.getFont());
                gl.setConstraints(tf, con);
                gridPanel.add(tf);
                this.field_list.add(tf);
            } else {
                label = new JLabel(prob.toString());
                label.setFont(this.getFont());
                gl.setConstraints(label, con);
                gridPanel.add(label);
                this.field_list.add(label);
            }
            ++i;
        }
        JPanel bottom = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.setFont(this.getFont());
        button.addActionListener(this);
        bottom.add(button);
        this.getRootPane().setDefaultButton(button);
        if (isEditable) {
            button = new JButton("Cancel");
            button.setActionCommand(button.getText());
            button.addActionListener(this);
            button.setFont(this.getFont());
            bottom.add(button);
        }
        JScrollPane gridPane = new JScrollPane(gridPanel, 20, 30);
        this.getContentPane().add((Component)gridPane, "Center");
        this.getContentPane().add((Component)bottom, "South");
        this.pack();
        this.setSize(gridPanel.getWidth() + 50, this.getHeight());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.getHeight() > screenSize.height - 200) {
            this.setSize(this.getWidth(), screenSize.height - 200);
        }
        if (this.getWidth() > screenSize.width - 200) {
            this.setSize(screenSize.width - 200, this.getHeight());
        }
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setProperties() {
        ArrayList<Double> probList = new ArrayList<Double>(this.field_list.size());
        int i = 0;
        try {
            i = 0;
            while (i < this.field_list.size()) {
                double curProb = Double.parseDouble(((JTextField)this.field_list.get(i)).getText());
                curProb = (double)Math.round(curProb * 100000.0) / 100000.0;
                probList.add(new Double(curProb));
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            this.canvas.showMessage("Error", "Utility field " + (i + 1) + " contains a non-numeric value.");
            return false;
        }
        this.node.initProbs(probList);
        return true;
    }

    @Override
    protected boolean actionOK() {
        return !this.isEditable || this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }
}

