/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.dialogs.InspectFactorDialog;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.AIspace.ve.Variable;

public class ReorderDialog
extends BasicDialog
implements ActionListener {
    protected InspectFactorDialog inspectFactorDialog;
    protected JList factorList;

    public ReorderDialog(JFrame parent, InspectFactorDialog dialog, Variable[] order) {
        super(parent, "Reorder Factor Variables", true, 2);
        this.inspectFactorDialog = dialog;
        this.construct(order);
        this.setSize(250, 175);
        this.centerWindow();
        this.setVisible(true);
    }

    protected void construct(Variable[] order) {
        this.setTitle("Reordering Factors");
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.getContentPane().add((Component)this.constructLeftPanel(order), "Center");
        this.getContentPane().add((Component)this.constructRightPanel(), "East");
    }

    protected JScrollPane constructLeftPanel(Variable[] order) {
        DefaultListModel<Variable> factorListModel = new DefaultListModel<Variable>();
        Variable[] variableArray = order;
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            Variable element = variableArray[n2];
            if (element == null) break;
            factorListModel.addElement(element);
            ++n2;
        }
        this.factorList = new JList(factorListModel);
        this.factorList.setSelectionMode(0);
        this.factorList.setCellRenderer(new FactorNameRenderer());
        this.factorList.setSelectedIndex(0);
        this.factorList.setVisibleRowCount(5);
        return new JScrollPane(this.factorList, 20, 31);
    }

    protected JPanel constructRightPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1));
        JButton button = new JButton("Shift Up");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        panel.add(button);
        button = new JButton("Shift Down");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        panel.add(button);
        panel.add(new JLabel(""));
        button = new JButton("OK");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        panel.add(button);
        this.getRootPane().setDefaultButton(button);
        return panel;
    }

    @Override
    protected boolean actionOK() {
        if (this.inspectFactorDialog != null) {
            this.reorderVariables();
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals("Shift Up")) {
            this.moveListSelectUp();
        } else if (e.getActionCommand().equals("Shift Down")) {
            this.moveListSelectDown();
        }
    }

    protected void moveListSelectUp() {
        int index = this.factorList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.factorList.getModel();
        Variable oldItem = (Variable)model.getElementAt(index - 1);
        model.setElementAt(this.factorList.getSelectedValue(), index - 1);
        model.setElementAt(oldItem, index);
        this.factorList.setSelectedIndex(index - 1);
        this.factorList.ensureIndexIsVisible(index - 1);
    }

    protected void moveListSelectDown() {
        DefaultListModel model;
        int index = this.factorList.getSelectedIndex();
        if (index == (model = (DefaultListModel)this.factorList.getModel()).getSize() - 1 || index < 0) {
            return;
        }
        Variable oldItem = (Variable)model.getElementAt(index + 1);
        model.setElementAt(this.factorList.getSelectedValue(), index + 1);
        model.setElementAt(oldItem, index);
        this.factorList.setSelectedIndex(index + 1);
        this.factorList.ensureIndexIsVisible(index + 1);
    }

    protected void reorderVariables() {
        DefaultListModel model = (DefaultListModel)this.factorList.getModel();
        Variable[] newOrder = new Variable[model.getSize()];
        int i = 0;
        while (i < model.getSize()) {
            newOrder[i] = (Variable)model.elementAt(i);
            ++i;
        }
        this.inspectFactorDialog.reorderColumns(newOrder);
    }

    protected class FactorNameRenderer
    extends JLabel
    implements ListCellRenderer {
        public FactorNameRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(((Variable)value).getName(false));
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }
}

